/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import java.util.List;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Enriches a given {@link Model POM} with a Maven Plugin
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public abstract class PluginPomEnricher implements PomEnricher {

  public static final String CONFIGURATION_ELEMENT = "configuration";

  @Override
  public abstract void generate(Model pomModel);

  protected Xpp3Dom createConfiguration(Xpp3Dom child) {
    final Xpp3Dom configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
    configuration.addChild(child);
    return configuration;
  }

  protected PluginExecution createExecution(String id, List<String> goals, String phase) {
    final PluginExecution pluginExecution = new PluginExecution();
    pluginExecution.setId(id);
    pluginExecution.setGoals(goals);
    pluginExecution.setPhase(phase);
    return pluginExecution;
  }

  protected Plugin createPlugin(String groupId, String artifactId, String version, Xpp3Dom configuration,
                                List<PluginExecution> executions, boolean extensions) {
    Plugin plugin = new Plugin();
    plugin.setGroupId(groupId);
    plugin.setArtifactId(artifactId);
    plugin.setVersion(version);
    if (extensions) {
      plugin.setExtensions(true);
    }
    plugin.setConfiguration(configuration);
    plugin.setExecutions(executions);
    return plugin;
  }

  protected Build getBuildNode(Model pomModel) {
    Build build = pomModel.getBuild();
    if (pomModel.getBuild() == null) {
      build = new Build();
      pomModel.setBuild(build);
    }

    return build;
  }

}
