/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.junit;

import junit.framework.TestCase;


/**
 * This is the java representation of a Munit test written with mule code.
 * 
 * The MUnit tests can be converted into Junit tests by extending the class {@link InternalMunitSuite}. When user do that instead
 * of creating a MunitTest Munit core creates this class which extends from {@link TestCase}
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
// TODO use the same class as the one in mule package check to use Default method implementations Java 8
public class InternalMunitTest extends TestCase {

  // /**
  // * The list of flows to be executed before the test
  // */
  // private List<MunitFlow> before;
  //
  // /**
  // * The test flow to be executed
  // */
  // private MunitTestFlow flow;
  //
  // /**
  // * The list of flows to be executed after the test
  // */
  // private List<MunitFlow> after;
  //
  // /**
  // * The mule context, used to access mule configuration/registry
  // */
  // private MuleContext muleContext;
  //
  // /**
  // * Hander of the test results. It manages the way the results are shown.
  // */
  // private TestOutputHandler outputHandler = new DefaultOutputHandler();
  //
  //
  // public InternalMunitTest(List<MunitFlow> before, MunitTestFlow flow, List<MunitFlow> after) {
  // this.before = before;
  // this.flow = flow;
  // this.after = after;
  // this.muleContext = flow.getMuleContext();
  // }
  //
  // public String getName() {
  // return flow.getName();
  // }
  //
  // @Override
  // public int countTestCases() {
  // return 1;
  // }
  //
  // /**
  // * <p>
  // * Runs the munit flow and handles the result. In case of failure it changes the java stack trace to the mule stack trace.
  // * </p>
  // *
  // * @throws Throwable
  // */
  // @Override
  // protected void runTest() throws Throwable {
  // if (flow.isIgnore()) {
  // return;
  // }
  //
  // // TODO SHARE EVENTS
  // Event event = muleEvent();
  // run(event, before);
  //
  // showDescription();
  // try {
  // flow.run(event);
  // } catch (Throwable t) {
  // t.setStackTrace(buildMuleStackTrace(event.getMuleContext()).toArray(new StackTraceElement[] {}));
  // throw t;
  // } finally {
  // MunitCore.reset(muleContext);
  // run(event, after);
  // }
  // }
  //
  // private void run(Event event, List<MunitFlow> flows) throws MuleException {
  // if (flows != null) {
  // for (MunitFlow flow : flows) {
  // outputHandler.printDescription(flow.getName(), flow.getDescription());
  // flow.process(event);
  // }
  // }
  // }
  //
  // // TODO really come on!
  // private void showDescription() {
  // outputHandler.printDescription(flow.getName(), flow.getDescription().replaceAll("\\.", "\\.%n"));
  // }
  //
  // protected Event muleEvent() {
  // return new EventBuilder(flow).withPayload("").build();
  // }

}

