/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class OldTestClassAdaptingListener
implements TestListener {
    private final RunNotifier fNotifier;

    public OldTestClassAdaptingListener(RunNotifier notifier) {
        this.fNotifier = notifier;
    }

    public void endTest(Test test) {
        this.fNotifier.fireTestFinished(this.asDescription(test));
    }

    public void startTest(Test test) {
        this.fNotifier.fireTestStarted(this.asDescription(test));
    }

    public void addError(Test test, Throwable t) {
        Failure failure = new Failure(this.asDescription(test), t);
        this.fNotifier.fireTestFailure(failure);
    }

    private Description asDescription(Test test) {
        if (test instanceof Describable) {
            Describable facade = (Describable)test;
            return facade.getDescription();
        }
        return Description.createTestDescription(this.getEffectiveClass(test), (String)this.getName(test));
    }

    private Class<? extends Test> getEffectiveClass(Test test) {
        return test.getClass();
    }

    private String getName(Test test) {
        if (test instanceof TestCase) {
            return ((TestCase)test).getName();
        }
        return test.toString();
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addError(test, (Throwable)t);
    }
}

