/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.junit;

import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

/**
 * <p>
 * Old Test Class Adapting Listener for JUnit
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class OldTestClassAdaptingListener implements TestListener {

  private final RunNotifier fNotifier;

  public OldTestClassAdaptingListener(RunNotifier notifier) {
    fNotifier = notifier;
  }

  public void endTest(junit.framework.Test test) {
    fNotifier.fireTestFinished(asDescription(test));
  }

  public void startTest(junit.framework.Test test) {
    fNotifier.fireTestStarted(asDescription(test));
  }

  public void addError(junit.framework.Test test, Throwable t) {
    Failure failure = new Failure(asDescription(test), t);
    fNotifier.fireTestFailure(failure);
  }

  private Description asDescription(junit.framework.Test test) {
    if (test instanceof Describable) {
      Describable facade = (Describable) test;
      return facade.getDescription();
    }
    return Description.createTestDescription(getEffectiveClass(test), getName(test));
  }

  private Class<? extends junit.framework.Test> getEffectiveClass(junit.framework.Test test) {
    return test.getClass();
  }

  private String getName(junit.framework.Test test) {
    if (test instanceof TestCase) {
      return ((TestCase) test).getName();
    } else {
      return test.toString();
    }
  }

  public void addFailure(Test test, AssertionFailedError t) {
    addError(test, t);
  }
}
