/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.junit;

/**
 * A helper class for configuring logging
 * on test cases
 * This is just a copy of the mule core class so we can have control over it
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class TestsLogConfigurationHelper {
  //
  //  public static final String LOG4J_CONFIGURATION_FILE = "log4j.configurationFile";
  //
  //  public static final String CONFIG_DEFAULT_FILE_NAME = "log4j2.xml";
  //  public static final String CONFIG_TEST_FILE_NAME = "log4j2-test.xml";
  //
  //  private static final String NULL_CONFIG_FILE = "NULL_CONFIG_FILE";
  //  private static final ThreadLocal<String> LOGGING_CONFIG_CACHE = new ThreadLocal<>();
  //
  //  /**
  //   * Looks for a logging config file on the directory tree
  //   * where the binaries for {@code testClass} resides.
  //   * If found, that logging config file is used, otherwise
  //   * Log4j2 is allowed to search for the config file using
  //   * its own logic.
  //   * <p/>
  //   * A file called {@code log4j2-test.xml} will be searched first.
  //   * If not found, will try with {@code log4j2.xml}.
  //   * <p/>
  //   * In either case, this method ends by reconfiguring all
  //   * loggers in the current {@link org.apache.logging.log4j.core.LoggerContext}
  //   *
  //   * @param testClass the class holding the tests to be executed
  //   */
  //  public static void configureLoggingForTest(Class<?> testClass) {
  //    String logConfigPath = LOGGING_CONFIG_CACHE.get();
  //
  //    if (logConfigPath == null) {
  //      logConfigPath = findLogConfigurationPath(testClass);
  //    }
  //
  //    forceConfigFile(logConfigPath);
  //  }
  //
  //  /**
  //   * Clears the configurations generated by
  //   * {@link #configureLoggingForTest(Class)}
  //   */
  //  public static void clearLoggingConfig() {
  //    LOGGING_CONFIG_CACHE.remove();
  //    System.clearProperty(LOG4J_CONFIGURATION_FILE);
  //  }
  //
  //  private static String findLogConfigurationPath(Class<?> testClass) {
  //    String encodedFolder = testClass.getClassLoader().getResource("").getPath().toString();
  //
  //    String folderPath;
  //    try {
  //      folderPath = URLDecoder.decode(encodedFolder, Charset.defaultCharset().name());
  //    } catch (UnsupportedEncodingException e) {
  //      return NULL_CONFIG_FILE;
  //    }
  //
  //    File folder = new File(folderPath);
  //
  //    if (folder != null && "target".equals(folder.getParentFile().getName())) {
  //      folder = folder.getParentFile();
  //    }
  //
  //    File logConfigFile = FileUtils.findFileByName(folder, CONFIG_TEST_FILE_NAME, true);
  //    if (logConfigFile == null) {
  //      logConfigFile = FileUtils.findFileByName(folder, CONFIG_DEFAULT_FILE_NAME, true);
  //    }
  //
  //    String logConfigPath =
  //        logConfigFile != null && logConfigFile.isFile() ? logConfigFile.toURI().toString() : NULL_CONFIG_FILE;
  //
  //    LOGGING_CONFIG_CACHE.set(logConfigPath);
  //    return logConfigPath;
  //  }
  //
  //  private static void forceConfigFile(String logConfigFile) {
  //    if (!NULL_CONFIG_FILE.equals(logConfigFile)) {
  //      System.setProperty(LOG4J_CONFIGURATION_FILE, logConfigFile);
  //    }
  //
  //    LoggerContext ctx = (LoggerContext) LogManager.getContext(false);
  //    ctx.reconfigure();
  //  }
}
