/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.junit;

import org.junit.runner.RunWith;

import junit.framework.TestSuite;

/**
 * Junit Runner to run Munit from Junit (Java)
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@RunWith(InternalRunner.class)
public abstract class InternalMunitSuite extends TestSuite {


  /**
   * Returns the path to the MUnit Configuration file
   * 
   * @return The path to the MUnit config.
   */
  public abstract String getConfigResources();

}
