/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runner.handler;

import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;

/**
 * <p>
 * Interface that handles Test Run Events
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public interface RunnerMessageHandler {

  default void handleSuiteStartFailure(String stackTrace) {}

  default void handleSuiteStart(String suiteFullPath) {}

  default void handleSuiteFinished(SuiteResult suiteResult) {}

  default void handleStandardOutputLine(String line) {}

  default void handleRunResult(RunResult runResult) {}

  default void handleSuiteFailure(SuiteResult suite) {}

  default void handleSuiteError(SuiteResult suite) {}

  default void handleUnexpectedError(String stackTrace) {}

}
