/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.mule.munit.plugin.maven.AbstractMunitMojo.MULE_ARTIFACT_JSON_FILE_NAME;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;

/**
 * Reads the mule application model and gives access to its properties based on the user settings
 * 
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class MuleApplicationModelLoader {

  private MuleApplicationModel muleApplicationModel;
  private String runtimeVersion;
  private String runtimeProduct;
  private Log log;

  public MuleApplicationModelLoader(MuleApplicationModel muleApplicationModel, Log log)
      throws MojoExecutionException {
    this.muleApplicationModel = muleApplicationModel;
    this.log = log;
  }

  public MuleApplicationModelLoader withRuntimeVersion(String runtimeVersion) {
    this.runtimeVersion = runtimeVersion;
    return this;
  }

  public MuleApplicationModelLoader withRuntimeProduct(String runtimeProduct) {
    this.runtimeProduct = runtimeProduct;
    return this;
  }

  public String getRuntimeVersion() {
    if (isNotBlank(runtimeVersion)) {
      return runtimeVersion;
    }
    String runtimeVersion = muleApplicationModel.getMinMuleVersion();
    log.debug("Runtime version set to " + runtimeVersion + " obtained from the " + MULE_ARTIFACT_JSON_FILE_NAME + " file");
    return runtimeVersion;
  }

  public String getRuntimeProduct() {
    if (isNotBlank(runtimeProduct)) {
      return runtimeProduct;
    }
    String runtimeProduct = muleApplicationModel.getRequiredProduct().name();
    log.debug("Runtime product set to " + runtimeProduct + " obtained from the " + MULE_ARTIFACT_JSON_FILE_NAME + " file");
    return runtimeProduct;
  }
}
