/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.ToolchainManager;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.locators.JVMLocator;
import org.mule.munit.plugin.maven.locators.TestSuiteFilesLocator;
import org.mule.munit.plugin.maven.runner.JVMStarter;
import org.mule.munit.plugin.maven.runner.MessageHandlerFactory;
import org.mule.munit.plugin.maven.runner.consumer.ErrorStreamConsumer;
import org.mule.munit.plugin.maven.runner.consumer.RunnerStreamConsumer;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.util.ArgLinesManager;
import org.mule.munit.plugin.maven.util.ClasspathManager;
import org.mule.munit.plugin.maven.util.JarFileFactory;
import org.mule.munit.plugin.maven.util.MuleApplicationModelLoader;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.plugin.maven.util.properties.UserPropertiesBuilder;
import org.mule.munit.remote.RemoteRunner;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public abstract class AbstractMunitMojo
extends AbstractMojo {
    protected static final String ARG_TOKEN = "-";
    protected static final String RUN_CONFIGURATION_ARG = "-run_configuration";
    public static final String RUN_CONFIGURATION_JSON = "run-configuration.json";
    public static final String STARTER_CLASS_FILE = "munitstarter";
    public static final String MUNIT_PREVIOUS_RUN_PLACEHOLDER = "MUNIT_PREVIOUS_RUN_PLACEHOLDER";
    protected static final Class REMOTE_RUNNER_CLASS = RemoteRunner.class;
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    public static final String MULE_ARTIFACT_JSON_FILE_NAME = "mule-artifact.json";
    @Parameter(property="munit.test")
    public String munitTest;
    @Parameter(property="munit.tags")
    public String munitTags;
    @Parameter(defaultValue="${skipMunitTests}")
    public boolean skipMunitTests = false;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit")
    public File munitTestsDirectory;
    @Parameter(property="project", required=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    public MavenSession session;
    @Parameter(defaultValue="${plugin.artifactId}")
    public String pluginArtifactId;
    @Parameter(property="redirectTestOutputToFile", defaultValue="false")
    public boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/output/")
    public File testOutputDirectory;
    @Parameter(property="enableSurefireReports", defaultValue="true")
    public boolean enableSurefireReports;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    public File surefireReportsFolder;
    @Parameter(property="skipAfterFailure", defaultValue="false")
    public boolean skipAfterFailure = false;
    @Parameter(property="argLines")
    public List<String> argLines;
    @Parameter(property="system.property.variables")
    public Map<String, String> systemPropertyVariables;
    @Parameter(property="environment.variables")
    public Map<String, String> environmentVariables;
    @Parameter(property="dynamic.ports")
    public List<String> dynamicPorts;
    @Component
    protected ToolchainManager toolchainManager;
    protected Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public List<File> suiteFiles;
    public JVMLocator jvmLocator;
    public JarFileFactory jarFileFactory;
    public ClasspathManager classpathManager;
    public MessageHandlerFactory messageHandlerFactory;
    public Map<String, String> effectiveSystemProperties;
    public WorkingDirectoryGenerator workingDirectoryGenerator;
    public MuleApplicationModelLoader muleApplicationModelLoader;
    public ResultPrinterFactory resultPrinterFactory;

    protected void init() throws MojoExecutionException {
        this.jarFileFactory = new JarFileFactory();
        this.messageHandlerFactory = new MessageHandlerFactory(this.getLog());
        this.effectiveSystemProperties = this.getEffectiveSystemProperties();
        this.jvmLocator = new JVMLocator(this.session, this.toolchainManager, this.getLog());
        this.workingDirectoryGenerator = new WorkingDirectoryGenerator(this.getLog(), this.getApplicationStructureGenerator(), this.project);
        this.classpathManager = new ClasspathManager(REMOTE_RUNNER_CLASS, this.getLog());
        this.muleApplicationModelLoader = this.getMuleApplicationModelLoader();
        this.resultPrinterFactory = this.getResultPrinterFactory();
    }

    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!this.skipMunitTests) {
                if (!this.hasExecutedBefore()) {
                    if (this.hasSuites()) {
                        this.init();
                        this.doExecute();
                    } else {
                        this.getLog().warn((CharSequence)"MUnit will not run, no MUnit suites found in your project");
                    }
                } else {
                    this.getLog().info((CharSequence)"Skipping execution of munit because it has already been run");
                }
            } else {
                this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_MUNIT_TESTS_PROPERTY));
            }
        } else {
            this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_TESTS_PROPERTY));
        }
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(MUNIT_PREVIOUS_RUN_PLACEHOLDER)) {
            return true;
        }
        this.getPluginContext().put(MUNIT_PREVIOUS_RUN_PLACEHOLDER, MUNIT_PREVIOUS_RUN_PLACEHOLDER);
        return false;
    }

    public void doExecute() throws MojoExecutionException {
        Map<TargetRuntime, RunConfiguration> runConfigurations = this.getRunConfigurations();
        HashMap<TargetRuntime, RunResult> runResults = new HashMap<TargetRuntime, RunResult>();
        try {
            for (Map.Entry<TargetRuntime, RunConfiguration> runConfigurationEntry : runConfigurations.entrySet()) {
                this.workingDirectoryGenerator.generate();
                TargetRuntime targetRuntime = runConfigurationEntry.getKey();
                this.getLog().info((CharSequence)String.format("Running %s with version %s", targetRuntime.getRuntimeProduct(), targetRuntime.getRuntimeVersion()));
                RunConfiguration runConfiguration = runConfigurationEntry.getValue();
                if (runConfiguration.getSuitePaths().isEmpty()) {
                    this.getLog().info((CharSequence)"No MUnit test suite files found. No test will be run");
                    return;
                }
                RunnerStreamConsumer streamConsumer = new RunnerStreamConsumer(this.messageHandlerFactory.create(this.redirectTestOutputToFile));
                ErrorStreamConsumer errorStreamConsumer = new ErrorStreamConsumer(this.redirectTestOutputToFile);
                int result = this.createTestRunExecutor(runConfiguration).execute(streamConsumer, (StreamConsumer)errorStreamConsumer);
                if (result == 0) {
                    RunResult runResult = streamConsumer.getRunResult();
                    runResults.put(targetRuntime, runResult);
                    continue;
                }
                throw new MojoExecutionException("Build Failed", (Exception)new MojoExecutionException(errorStreamConsumer.getOutput()));
            }
            runResults.forEach(this::handleRunResult);
            this.failBuildIfNecessary(runResults);
        }
        catch (IOException | CommandLineException e) {
            throw new MojoExecutionException("Build Failed", (Exception)e);
        }
    }

    protected JVMStarter createTestRunExecutor(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = this.saveRunConfigurationToFile(runConfiguration);
        return this.createJVMStarter(runConfigurationFile);
    }

    protected void handleRunResult(TargetRuntime targetRuntime, RunResult runResult) {
        for (ResultPrinter printer : this.resultPrinterFactory.create()) {
            printer.print(targetRuntime, runResult);
        }
    }

    protected void failBuildIfNecessary(Map<TargetRuntime, RunResult> runResults) throws MojoExecutionException {
        if (runResults.values().stream().anyMatch(RunResult::hasFailed)) {
            throw new MojoExecutionException("MUnit Tests Failed");
        }
    }

    protected abstract Map<TargetRuntime, RunConfiguration> getRunConfigurations() throws MojoExecutionException;

    protected abstract ResultPrinterFactory getResultPrinterFactory();

    protected abstract ApplicationStructureGenerator getApplicationStructureGenerator() throws MojoExecutionException;

    protected abstract File getMuleApplicationJsonPath();

    public List<String> getEffectiveArgLines(String starterJarFileName) {
        return new ArgLinesManager(this.argLines, starterJarFileName, this.getLog()).getEffectiveArgLines();
    }

    public JVMStarter createJVMStarter(File runConfigurationFile) throws IOException {
        this.getLog().debug((CharSequence)("MUnit root folder found at: " + this.munitTestsDirectory.getAbsolutePath()));
        String starterJarFileName = org.mule.munit.common.util.FileUtils.generateRandomFileName((String)STARTER_CLASS_FILE, (String)".jar");
        File jarFile = this.jarFileFactory.create(this.classpathManager.getEffectiveClasspath(), REMOTE_RUNNER_CLASS.getCanonicalName(), new File(this.project.getBuild().getDirectory()), starterJarFileName);
        JVMStarter jvmStarter = new JVMStarter(this.getLog()).withJVM(this.jvmLocator.locate()).withWorkingDirectory(this.getWorkingDirectory()).withJar(jarFile).withArgLines(this.getEffectiveArgLines(starterJarFileName)).withSystemProperties(this.effectiveSystemProperties).addEnvironmentVariables(this.environmentVariables);
        HashMap<String, File> fileArgLines = new HashMap<String, File>();
        fileArgLines.put(RUN_CONFIGURATION_ARG, runConfigurationFile);
        jvmStarter.withArgLines(fileArgLines);
        return jvmStarter;
    }

    public File saveRunConfigurationToFile(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = Paths.get(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), RUN_CONFIGURATION_JSON).toFile();
        this.saveAsJsonDataToFile(runConfiguration, runConfigurationFile);
        return runConfigurationFile;
    }

    protected void saveAsJsonDataToFile(Object data, File dataLocation) {
        try {
            if (dataLocation == null) {
                this.getLog().warn((CharSequence)"Unable to save data, no destination file was provided");
                return;
            }
            dataLocation.getParentFile().mkdirs();
            dataLocation.createNewFile();
            org.mule.munit.common.util.FileUtils.writeStringToFile((File)dataLocation, (String)this.gson.toJson(data), (Charset)Charset.defaultCharset());
            this.getLog().debug((CharSequence)("Data File saved in " + dataLocation));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to save data to file:" + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
    }

    protected MuleApplicationModelLoader getMuleApplicationModelLoader() throws MojoExecutionException {
        return new MuleApplicationModelLoader(this.getMuleApplicationModel(), this.getLog());
    }

    protected MuleApplicationModel getMuleApplicationModel() throws MojoExecutionException {
        File muleApplicationJsonPath = this.getMuleApplicationJsonPath();
        try {
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleApplicationJsonPath, (Charset)Charset.defaultCharset()));
        }
        catch (IOException e) {
            String message = "Fail to read mule application file from " + muleApplicationJsonPath;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    public File getWorkingDirectory() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return new File(".");
    }

    private Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        effectiveSystemProperties.putAll(this.getUserSystemProperties());
        effectiveSystemProperties.put("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        return effectiveSystemProperties;
    }

    private Map<String, String> getUserSystemProperties() {
        return new UserPropertiesBuilder(this.project.getBuild().getDirectory(), this.getLog()).withSystemPropertyVariables(this.systemPropertyVariables).withDynamicPorts(this.dynamicPorts).withUserProperties(this.session != null ? this.session.getUserProperties() : null).build();
    }

    private boolean hasSuites() {
        this.suiteFiles = new TestSuiteFilesLocator().locateFiles(this.munitTestsDirectory);
        return !this.suiteFiles.isEmpty();
    }
}

