/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class TargetRuntime {
    private static final String TARGET_RUNTIME_SEPARATOR = ":";
    private String runtimeVersion;
    private String runtimeProduct;

    public TargetRuntime(String runtimeVersion, String runtimeProduct) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeVersion), (Object)"Version cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeProduct), (Object)"Product cannot be blank");
        this.runtimeVersion = runtimeVersion;
        this.runtimeProduct = runtimeProduct;
    }

    public static TargetRuntime parse(String targetRuntime) {
        String[] versionAndProduct = StringUtils.split((String)targetRuntime, (String)TARGET_RUNTIME_SEPARATOR);
        if (versionAndProduct.length != 2) {
            throw new IllegalArgumentException("Target runtime should be in the form of <product>:<version>. For example MULE_EE:4.1.1");
        }
        String product = versionAndProduct[0];
        String version = versionAndProduct[1];
        return new TargetRuntime(version, product);
    }

    public String getRuntimeProduct() {
        return this.runtimeProduct;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetRuntime that = (TargetRuntime)o;
        return this.runtimeVersion.equals(that.runtimeVersion) && this.runtimeProduct.equals(that.runtimeProduct);
    }

    public int hashCode() {
        int result = this.runtimeVersion != null ? this.runtimeVersion.hashCode() : 0;
        result = 31 * result + (this.runtimeProduct != null ? this.runtimeProduct.hashCode() : 0);
        return result;
    }
}

