/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public class JVMLocator {
    private Log log;
    private MavenSession session;
    private ToolchainManager toolchainManager;

    public JVMLocator(MavenSession session, ToolchainManager toolchainManager, Log log) {
        this.log = log;
        this.session = session;
        this.toolchainManager = toolchainManager;
    }

    public String locate() {
        String jvm = "";
        Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            jvm = toolchain.findTool("java");
        }
        if (StringUtils.isEmpty((CharSequence)jvm)) {
            jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        this.log.debug((CharSequence)("Using JVM: " + jvm));
        return jvm;
    }

    protected Toolchain getToolchain() {
        Toolchain toolchain = null;
        if (this.toolchainManager != null && this.session != null) {
            toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return toolchain;
    }
}

