/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.runner.handler.RunnerMessageHandler;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;

public class TestOutputMessageHandler
implements RunnerMessageHandler {
    private Map<String, List<String>> suiteOutputs = new HashMap<String, List<String>>();
    private List<String> suiteOutput = new ArrayList<String>();
    private String currentSuite;
    private Log log;

    public TestOutputMessageHandler(Log log) {
        this.log = log;
    }

    @Override
    public void handleSuiteFinished(SuiteResult suiteResult) {
        this.suiteOutputs.put(suiteResult.getSuitePath(), new ArrayList<String>(this.suiteOutput));
        this.printTestSuiteFinished(suiteResult);
        this.currentSuite = null;
    }

    @Override
    public void handleSuiteStartFailure(String stackTrace) {
        this.printContainerFailedToStart(stackTrace);
        this.currentSuite = null;
    }

    @Override
    public void handleSuiteStart(String suitePath) {
        this.printTestSuiteStart(suitePath);
        this.suiteOutput.clear();
        this.currentSuite = suitePath;
    }

    @Override
    public void handleStandardOutputLine(String message) {
        if (this.shouldPrintDebugLine()) {
            System.out.println(message);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currentSuite)) {
            this.suiteOutput.add(message);
        }
    }

    @Override
    public void handleRunResult(RunResult runResult) {
        runResult.setSuiteOutputs(this.suiteOutputs);
    }

    @Override
    public void handleSuiteFailure(SuiteResult suiteResult) {
        this.handleSuiteErrorOrFailure(suiteResult, "FAILURE");
    }

    @Override
    public void handleSuiteError(SuiteResult suiteResult) {
        this.handleSuiteErrorOrFailure(suiteResult, "ERROR");
    }

    @Override
    public void handleUnexpectedError(String stackTrace) {
        System.out.println("An unexpected error occurred");
        System.out.println(stackTrace);
    }

    protected void handleSuiteErrorOrFailure(SuiteResult suiteResult, String tag) {
        this.printTestSuiteFailedOrError(FilenameUtils.getName((String)suiteResult.getSuitePath()), suiteResult.getCause(), tag);
        this.suiteOutput.add(suiteResult.getCause());
        this.suiteOutputs.put(suiteResult.getSuitePath(), new ArrayList<String>(this.suiteOutput));
        this.currentSuite = null;
    }

    private boolean shouldPrintDebugLine() {
        return this.currentSuite == null && this.log.isDebugEnabled();
    }

    private void printTestSuiteStart(String suitePath) {
        System.out.format("Running %s\n", suitePath);
    }

    private void printTestSuiteFinished(SuiteResult suiteResult) {
        System.out.format("Tests run: %d, Failures: %d, Errors: %d, Skipped: %d, Time elapsed: %.3f sec\n", suiteResult.getNumberOfTests(), suiteResult.getNumberOfFailures(), suiteResult.getNumberOfErrors(), suiteResult.getNumberOfIgnores(), Float.valueOf((float)suiteResult.getTime() / 1000.0f));
    }

    private void printContainerFailedToStart(String cause) {
        System.out.println("Container failed to start");
        System.out.println(cause);
    }

    private void printTestSuiteFailedOrError(String suitePath, String cause, String tag) {
        System.out.format("%s failed <<< %s\n", suitePath, tag);
        System.out.println(cause);
    }
}

