/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;

public class MuleApplicationModelLoader {
    private MuleApplicationModel muleApplicationModel;
    private String runtimeVersion;
    private String runtimeProduct;
    private Log log;

    public MuleApplicationModelLoader(MuleApplicationModel muleApplicationModel, Log log) throws MojoExecutionException {
        this.muleApplicationModel = muleApplicationModel;
        this.log = log;
    }

    public MuleApplicationModelLoader withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public MuleApplicationModelLoader withRuntimeProduct(String runtimeProduct) {
        this.runtimeProduct = runtimeProduct;
        return this;
    }

    public String getRuntimeVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        String runtimeVersion = this.muleApplicationModel.getMinMuleVersion();
        this.log.debug((CharSequence)("Runtime version set to " + runtimeVersion + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeVersion;
    }

    public String getRuntimeProduct() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeProduct)) {
            return this.runtimeProduct;
        }
        String runtimeProduct = this.muleApplicationModel.getRequiredProduct().name();
        this.log.debug((CharSequence)("Runtime product set to " + runtimeProduct + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeProduct;
    }
}

