/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;

public class RemoteRepositoriesLocator {
    private static final String SNAPSHOTS = "https://repository-master.mulesoft.org/nexus/content/repositories/snapshots";
    private static final String RELEASES = "https://repository-master.mulesoft.org/nexus/content/repositories/releases";
    private static final String RELEASES_EE = "https://repository-master.mulesoft.org/nexus/content/repositories/releases-ee";
    private static final String CI_SNAPSHOTS = "https://repository-master.mulesoft.org/nexus/content/repositories/ci-snapshots";
    private static final String SNAPSHOTS_PROXY = "https://repository.mulesoft.org/nexus/content/repositories/snapshots";
    private static final String RELEASES_PROXY = "https://repository.mulesoft.org/nexus/content/repositories/releases";
    private static final String RELEASES_EE_PROXY = "https://repository.mulesoft.org/nexus/content/repositories/releases-ee";
    private static final String CI_SNAPSHOTS_PROXY = "https://repository.mulesoft.org/nexus/content/repositories/ci-snapshots";
    private static final String RELEASES_SHORT_PROXY = "https://repository.mulesoft.org/releases";
    private static final String SNAPSHOTS_SHORT_PROXY = "https://repository.mulesoft.org/snapshots";
    protected static final List<String> WHITELISTED_REPOSITORIES = Arrays.asList("https://repository-master.mulesoft.org/nexus/content/repositories/releases", "https://repository-master.mulesoft.org/nexus/content/repositories/snapshots", "https://repository.mulesoft.org/nexus/content/repositories/releases", "https://repository.mulesoft.org/nexus/content/repositories/releases-ee", "https://repository.mulesoft.org/nexus/content/repositories/ci-snapshots", "https://repository.mulesoft.org/releases", "https://repository.mulesoft.org/snapshots", "https://repository.mulesoft.org/nexus/content/repositories/snapshots", "https://repository-master.mulesoft.org/nexus/content/repositories/releases-ee", "https://repository-master.mulesoft.org/nexus/content/repositories/ci-snapshots");
    private boolean whitelistRepositories = false;
    private List<RemoteRepository> remoteRepositories;

    public RemoteRepositoriesLocator(MavenProject mavenProject) {
        Preconditions.checkArgument((mavenProject != null ? 1 : 0) != 0, (Object)"Maven Project cannot be null");
        this.remoteRepositories = mavenProject.getRemoteProjectRepositories();
    }

    public RemoteRepositoriesLocator setWhiteListRepositories(boolean whitelistRepositories) {
        this.whitelistRepositories = whitelistRepositories;
        return this;
    }

    public List<RemoteRepository> locate() {
        return this.whitelistRepositories ? this.filterRepositories(this.remoteRepositories) : this.remoteRepositories;
    }

    private List<RemoteRepository> filterRepositories(List<RemoteRepository> repositories) {
        return repositories.stream().filter(this::isWhiteListed).collect(Collectors.toList());
    }

    private boolean isWhiteListed(RemoteRepository remoteRepository) {
        return WHITELISTED_REPOSITORIES.stream().anyMatch(whitelistedRepo -> remoteRepository.getUrl().startsWith((String)whitelistedRepo));
    }
}

