/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.aether.AetherRuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.exception.NoLatestVersionFoundException;
import com.mulesoft.anypoint.discovery.api.exception.VersionDiscoveryException;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.runtime.api.deployment.meta.Product;

public class RuntimeVersionProviderFactory {
    private Log log;
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private List<RemoteRepository> remoteRepositories;

    public RuntimeVersionProviderFactory(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories, Log log) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
        this.log = log;
    }

    public Optional<RuntimeVersionProvider> create(Product product) throws MojoExecutionException {
        try {
            this.validateRepositories(this.remoteRepositories);
            return Optional.of(new AetherRuntimeVersionProvider(this.repositorySystem, this.repositorySystemSession, this.remoteRepositories, product));
        }
        catch (VersionDiscoveryException e) {
            throw new MojoExecutionException("An error occured while discovering versions for product " + product + " in the following repositories " + this.remoteRepositories);
        }
        catch (NoLatestVersionFoundException e) {
            this.log.warn((CharSequence)("Unable to find Mule Runtime versions for product " + product));
            return Optional.empty();
        }
    }

    private void validateRepositories(List<RemoteRepository> remoteRepositories) throws MojoExecutionException {
        if (remoteRepositories.isEmpty()) {
            throw new MojoExecutionException("No repositories found to discover runtimes");
        }
    }
}

