/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.printer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.report.xml.CdataAwareXppDriver;
import org.mule.munit.plugin.maven.report.xml.Property;
import org.mule.munit.plugin.maven.report.xml.TestCase;
import org.mule.munit.plugin.maven.report.xml.TestSuite;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;
import org.mule.munit.plugin.maven.runner.model.TestResult;
import org.mule.munit.plugin.maven.runner.printer.FileResultPrinter;

public class XmlResultPrinter
extends FileResultPrinter {
    private static final float MILLIS_FACTOR = 1000.0f;
    private static final String XML_REPORT_HEADER = "TEST-munit";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator();
    private TestSuite suite;
    private String name;
    private Map<String, String> systemProperties;

    public XmlResultPrinter(File reportBasePath, Map<String, String> systemProperties, Log log) {
        super(reportBasePath, log);
        this.systemProperties = systemProperties;
    }

    @Override
    public void print(TargetRuntime targetRuntime, RunResult runResult) {
        try {
            for (SuiteResult suiteResult : runResult.getSuites()) {
                this.printSuiteResult(targetRuntime, suiteResult);
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printSuiteResult(TargetRuntime targetRuntime, SuiteResult result) throws FileNotFoundException, UnsupportedEncodingException {
        CdataAwareXppDriver xppDriver = new CdataAwareXppDriver();
        XStream xStream = new XStream((HierarchicalStreamDriver)xppDriver);
        xStream.autodetectAnnotations(true);
        String suiteRelativePath = result.getSuitePath();
        suiteRelativePath = suiteRelativePath + result.getParameterization().map(parameterization -> "[" + parameterization + "]").orElse("");
        this.name = FilenameUtils.getName((String)suiteRelativePath).replace(".xml", "");
        this.suite = new TestSuite(this.dumpProperties(System.getProperties(), this.systemProperties), this.name);
        for (TestResult testResult : result.getTests()) {
            this.printTestResult(testResult);
        }
        this.suite.setErrors(result.getNumberOfErrors());
        this.suite.setFailures(result.getNumberOfFailures());
        this.suite.setTests(result.getNumberOfTests());
        this.suite.setTime((float)result.getTime() / 1000.0f);
        this.suite.setSkipped(result.getNumberOfIgnores());
        String suiteReportName = this.name.replace("/", ".") + ".xml";
        PrintStream out = this.getResultPrintStream(String.format("%s.%s.%s.%s", XML_REPORT_HEADER, targetRuntime.getRuntimeProduct(), targetRuntime.getRuntimeVersion(), suiteReportName));
        out.print(XML_HEADER + xStream.toXML((Object)this.suite));
    }

    public void printTestResult(TestResult testResult) {
        TestCase testCase = new TestCase((float)testResult.getTime() / 1000.0f, this.name, testResult.getTestName());
        testCase.setSkipped(testResult.isIgnored());
        if (testResult.hasFailed()) {
            testCase.setFailure(testResult.getCause());
        }
        if (testResult.hasError()) {
            testCase.setError(testResult.getCause());
        }
        this.suite.add(testCase);
    }

    private List<Property> dumpProperties(Properties properties, Map<String, String> sysProps) {
        ArrayList<Property> testProperties = new ArrayList<Property>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (sysProps.containsKey(entry.getKey())) continue;
            testProperties.add(new Property((String)entry.getKey(), this.sanitize((String)entry.getValue())));
        }
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            testProperties.add(new Property((String)entry.getKey(), (String)entry.getValue()));
        }
        return testProperties;
    }

    private String sanitize(String value) {
        if (XmlResultPrinter.containsEscapesIllegalXml10(value)) {
            return XmlResultPrinter.escapeXml(value, true);
        }
        return value;
    }

    private static boolean containsEscapesIllegalXml10(String message) {
        int size = message.length();
        for (int i = 0; i < size; ++i) {
            if (!XmlResultPrinter.isIllegalEscape(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalEscape(char c) {
        return XmlResultPrinter.isIllegalEscape((int)c);
    }

    private static boolean isIllegalEscape(int c) {
        return c >= 0 && c < 32 && c != 10 && c != 13 && c != 9;
    }

    private static String escapeXml(String text, boolean attribute) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (XmlResultPrinter.isIllegalEscape(c)) {
                sb.append(attribute ? "&#" : "&amp#").append((int)c).append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

