/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.ProductDiscoveryMode;
import org.mule.munit.plugin.maven.RuntimeProducts;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.util.RuntimeVersionProviderFactory;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.meta.MuleVersion;

public class RuntimeVersionsLocator {
    private static final MuleVersion PATCH_VERSION_4_1 = new MuleVersion("4.1.1");
    private RuntimeVersionProviderFactory runtimeVersionProviderFactory;
    private ProductDiscoveryMode productDiscoveryMode;
    private String minMuleVersion;
    private boolean includeSnapshots;
    private Log log;
    private boolean useLatestPatches;

    public RuntimeVersionsLocator(RuntimeVersionProviderFactory runtimeVersionProviderFactory, Log log) {
        this.runtimeVersionProviderFactory = runtimeVersionProviderFactory;
        this.log = log;
    }

    public RuntimeVersionsLocator withMinMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
        return this;
    }

    public RuntimeVersionsLocator withProductDiscoveryMode(ProductDiscoveryMode productDiscoveryMode) {
        this.productDiscoveryMode = productDiscoveryMode;
        return this;
    }

    public RuntimeVersionsLocator includingSnapshots(boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    public RuntimeVersionsLocator usingLatestPatches(boolean useLatestPatches) {
        this.useLatestPatches = useLatestPatches;
        return this;
    }

    public Set<TargetRuntime> locate() throws MojoExecutionException {
        List<ArtifactVersion> eeVersions = this.productDiscoveryMode.supportsEe() ? this.locateRuntimes(this.runtimeVersionProviderFactory, Product.MULE_EE) : Collections.emptyList();
        List<ArtifactVersion> ceVersions = this.productDiscoveryMode.supportsCe() ? this.locateRuntimes(this.runtimeVersionProviderFactory, Product.MULE) : Collections.emptyList();
        Stream<TargetRuntime> targetRuntimes = this.createTargetRuntimes(eeVersions, ceVersions).filter(this::isNotCePatchVersion).filter(this::includeSnapshots).filter(this::greaterThanMinVersion);
        if (this.useLatestPatches) {
            targetRuntimes = this.filterLatestPatches(targetRuntimes);
        }
        this.log.debug((CharSequence)("Discovered Mule runtimes: " + targetRuntimes));
        return targetRuntimes.collect(Collectors.toCollection(TreeSet::new));
    }

    private boolean isNotCePatchVersion(TargetRuntime targetRuntime) {
        if (targetRuntime.getRuntimeProduct().equals(RuntimeProducts.CE.value())) {
            MuleVersion muleVersion = new MuleVersion(targetRuntime.getRuntimeVersion());
            return muleVersion.getRevision() == 0 || muleVersion.equals((Object)PATCH_VERSION_4_1);
        }
        return true;
    }

    private Stream<TargetRuntime> createTargetRuntimes(List<ArtifactVersion> eeVersions, List<ArtifactVersion> ceVersions) {
        Stream<TargetRuntime> ceRuntimes = ceVersions.stream().map(version -> this.toTargetRuntime((ArtifactVersion)version, Product.MULE));
        Stream<TargetRuntime> eeRuntimes = eeVersions.stream().map(version -> this.toTargetRuntime((ArtifactVersion)version, Product.MULE_EE));
        return Stream.concat(ceRuntimes, eeRuntimes);
    }

    private List<ArtifactVersion> locateRuntimes(RuntimeVersionProviderFactory versionProviderFactory, Product product) throws MojoExecutionException {
        return versionProviderFactory.create(product).map(RuntimeVersionProvider::all).orElse(Collections.emptyList());
    }

    private boolean greaterThanMinVersion(TargetRuntime targetRuntime) {
        return new MuleVersion(targetRuntime.getRuntimeVersion()).atLeast(this.minMuleVersion);
    }

    private boolean includeSnapshots(TargetRuntime targetRuntime) {
        MuleVersion muleVersion = new MuleVersion(targetRuntime.getRuntimeVersion());
        if (muleVersion.hasSuffix()) {
            return this.includeSnapshots && "SNAPSHOT".equals(muleVersion.getSuffix());
        }
        return true;
    }

    private TargetRuntime toTargetRuntime(ArtifactVersion artifactVersion, Product product) {
        return new TargetRuntime(artifactVersion.value(), product.name());
    }

    private Stream<TargetRuntime> filterLatestPatches(Stream<TargetRuntime> targetRuntimes) {
        HashMap latestPatches = new HashMap();
        targetRuntimes.forEach(targetRuntime -> {
            MuleVersion version = new MuleVersion(targetRuntime.getRuntimeVersion());
            String versionKey = String.format("%d.%d%s", version.getMajor(), version.getMinor(), version.getSuffix());
            if (latestPatches.containsKey(versionKey)) {
                TargetRuntime currentLatest = (TargetRuntime)latestPatches.get(versionKey);
                if (version.newerThan(currentLatest.getRuntimeVersion())) {
                    latestPatches.put(versionKey, targetRuntime);
                }
            } else {
                latestPatches.put(versionKey, targetRuntime);
            }
        });
        return latestPatches.values().stream();
    }
}

