/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runtime;

/**
 * Indicates which runtimes to discover
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public enum ProductDiscoveryMode {

  CE(true, false), EE(false, true), ALL(true, true);

  private boolean supportsCe;
  private boolean supportsEe;

  ProductDiscoveryMode(boolean supportsCe, boolean supportsEe) {
    this.supportsCe = supportsCe;
    this.supportsEe = supportsEe;
  }

  public boolean supportsCe() {
    return supportsCe;
  }

  public boolean supportsEe() {
    return supportsEe;
  }

}
