/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.printer;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.report.xml.sonar.SonarFile;
import org.mule.munit.plugin.maven.report.xml.sonar.SonarTestCase;
import org.mule.munit.plugin.maven.report.xml.sonar.SonarTestExecutions;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;
import org.mule.munit.plugin.maven.runner.model.TestResult;
import org.mule.munit.plugin.maven.runner.printer.FileResultPrinter;
import org.mule.munit.plugin.maven.runtime.TargetRuntime;

public class SonarResultFilePrinter
extends FileResultPrinter {
    private static final String MUNIT_PATH = "src/test/munit";

    public SonarResultFilePrinter(File reportBasePath, Log log) {
        super(reportBasePath, log);
    }

    @Override
    public void print(TargetRuntime targetRuntime, RunResult runResult) {
        try {
            for (SuiteResult suiteResult : runResult.getSuites()) {
                this.printSuiteResult(targetRuntime, suiteResult);
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printSuiteResult(TargetRuntime targetRuntime, SuiteResult result) throws FileNotFoundException, UnsupportedEncodingException {
        String parameterization = result.getParameterization().map(p -> ".[" + p + "]").orElse("");
        String name = String.format("%s.%s%s.xml", targetRuntime.getRuntimeProduct(), targetRuntime.getRuntimeVersion(), parameterization);
        SonarTestExecutions sonarTestExecutions = this.readExistReport(name);
        String suitePath = new File(MUNIT_PATH, result.getSuitePath()).getPath();
        SonarFile suite = new SonarFile(suitePath);
        sonarTestExecutions.add(suite);
        for (TestResult testResult : result.getTests()) {
            this.printTestResult(testResult, suite);
        }
        XStream xStream = this.createSecureXStream();
        PrintStream out = this.getResultPrintStream(String.format("%s", name));
        out.print(xStream.toXML((Object)sonarTestExecutions));
    }

    public void printTestResult(TestResult testResult, SonarFile suite) {
        SonarTestCase testCase = new SonarTestCase(testResult.getTime(), testResult.getTestName());
        if (testResult.isIgnored()) {
            testCase.setSkipped(testResult.getCause());
        } else if (testResult.hasFailed()) {
            testCase.setFailure(testResult.getCause());
        } else if (testResult.hasError()) {
            testCase.setError(testResult.getCause());
        }
        suite.add(testCase);
    }

    private SonarTestExecutions readExistReport(String fileName) {
        File report = new File(this.reportBasePath, fileName);
        if (!report.exists()) {
            return new SonarTestExecutions();
        }
        try {
            XStream xStream = this.createSecureXStream();
            SonarTestExecutions sonarReport = (SonarTestExecutions)xStream.fromXML(report);
            return sonarReport;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SonarTestExecutions();
        }
    }

    private XStream createSecureXStream() {
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(new String[]{"org.mule.**"});
        xStream.alias("testExecutions", SonarTestExecutions.class);
        xStream.autodetectAnnotations(true);
        return xStream;
    }
}

