/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.locators;

import static java.util.Collections.emptyList;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;

/**
 * <p>
 * Locates all Test Configuration files
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class TestConfigFilesLocator implements FilesLocator {

  private static final String[] MUNIT_TEST_SUITE_FILE_EXTENSIONS = {"xml"};

  public List<File> locateFiles(File folder) {
    if (folder == null || !folder.exists()) {
      return emptyList();
    }
    return new ArrayList<>(FileUtils.listFiles(folder, MUNIT_TEST_SUITE_FILE_EXTENSIONS, true));
  }
}
