/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runner.model;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.util.ArgLinesManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * This class defines the configuration of the debugger
 *
 * @author Mulesoft Inc.
 */
public class Debugger {

  /**
   *
   * @author Mulesoft Inc.
   */
  public enum Type {
    ANYPOINT_CODE_BUILDER
  }

  /**
   * TODO Define format and parse the string
   */
  public static Debugger fromString(String value) {
    String[] values = StringUtils.isBlank(value) ? new String[] {""} : value.split(":");

    if (!"ACBDebugger".equals(values[0])) {
      return new Debugger(false, null, 0, "", null, false);
    }

    if (values.length < 2 || StringUtils.isEmpty(values[1])) {
      throw new IllegalArgumentException("A lockId is required");
    }

    int debuggerPort = values.length < 3 || StringUtils.isBlank(values[2]) ? 4555 : Integer.parseInt(values[2]);
    String debuggerVersion = values.length < 4 || StringUtils.isBlank(values[3]) ? "1.0.25" : values[3];
    boolean withDebug = values.length >= 5 && Boolean.parseBoolean(values[4]);
    return new Debugger(true, Type.ANYPOINT_CODE_BUILDER, debuggerPort, debuggerVersion, values[1], withDebug);
  }

  private final Boolean addDebugger;
  private final Type type;
  private final Integer debuggerPort;
  private final String debuggerVersion;
  private final String lockId;
  private final Boolean withDebug;

  public Debugger(Boolean addDebugger, Type type, Integer debuggerPort, String debuggerVersion, String lockId,
                  Boolean withDebug) {
    this.addDebugger = addDebugger;
    this.type = type;
    this.debuggerPort = debuggerPort;
    this.debuggerVersion = debuggerVersion;
    this.lockId = lockId;
    this.withDebug = withDebug;
  }

  public Boolean getAddDebugger() {
    return addDebugger;
  }

  public Type getType() {
    return type;
  }

  public Integer getDebuggerPort() {
    return debuggerPort;
  }

  public String getDebuggerVersion() {
    return debuggerVersion;
  }

  public List<String> getArguments() {
    if (!addDebugger) {
      return Collections.emptyList();
    }

    ArrayList<String> values = new ArrayList<>(2);
    values.add("-Dmule.debug.port=" + debuggerPort);
    values.add("-DACBDebugger=true");

    if (withDebug) {
      values.add(ArgLinesManager.DEFAULT_DEBUG_ARG_LINE);
    }

    return ImmutableList.copyOf(values);
  }

  public String getLockId() {
    return lockId;
  }

  public Boolean getWithDebug() {
    return withDebug;
  }
}
