/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.runtime.DiscoverRuntimes;

public class RuntimeConfiguration {
    public static final String ADDITIONAL_RUNTIMES_PROPERTY = "additionalRuntimes";
    public static final String ADDITIONAL_RUNTIME_SEPARATOR = ",";
    private DiscoverRuntimes discoverRuntimes;
    private List<String> additionalRuntimes = Collections.emptyList();

    public RuntimeConfiguration() {
    }

    private RuntimeConfiguration(DiscoverRuntimes discoverRuntimes, List<String> additionalRuntimes) {
        this.discoverRuntimes = discoverRuntimes;
        this.additionalRuntimes = additionalRuntimes;
    }

    public Optional<DiscoverRuntimes> getDiscoverRuntimes() {
        return Optional.ofNullable(this.discoverRuntimes);
    }

    public List<String> getAdditionalRuntimes() {
        return this.additionalRuntimes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DiscoverRuntimes discoverRuntimes;
        private List<String> additionalRuntimes = Collections.emptyList();

        public Builder from(RuntimeConfiguration runtimeConfiguration) {
            if (runtimeConfiguration == null) {
                return this;
            }
            runtimeConfiguration.getDiscoverRuntimes().ifPresent(discRunt -> {
                this.discoverRuntimes = DiscoverRuntimes.builder().from((DiscoverRuntimes)discRunt).build();
            });
            this.additionalRuntimes = runtimeConfiguration.getAdditionalRuntimes();
            return this;
        }

        public Builder withDiscoverRuntimes(DiscoverRuntimes discoverRuntimes) {
            this.discoverRuntimes = discoverRuntimes;
            return this;
        }

        public Builder withAdditionalRuntimes(List<String> additionalRuntimes) {
            this.additionalRuntimes = additionalRuntimes;
            return this;
        }

        public Builder withOverrides(Properties userProperties) {
            this.discoverRuntimes = DiscoverRuntimes.builder().from(this.discoverRuntimes).withOverrides(userProperties).build();
            if (userProperties.containsKey(RuntimeConfiguration.ADDITIONAL_RUNTIMES_PROPERTY)) {
                this.additionalRuntimes = Arrays.asList(StringUtils.split((String)userProperties.getProperty(RuntimeConfiguration.ADDITIONAL_RUNTIMES_PROPERTY), (String)RuntimeConfiguration.ADDITIONAL_RUNTIME_SEPARATOR));
            }
            return this;
        }

        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this.discoverRuntimes, this.additionalRuntimes);
        }
    }
}

