/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util;

import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetRuntime;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.EmbeddedContainerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;

import java.io.File;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/**
 * Creates {@link RunConfiguration} based on basic MUnit parameters for Embedded
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class BaseApplicationRunConfigurationFactory extends BaseRunConfigurationFactory {

  public BaseApplicationRunConfigurationFactory(Log log, String projectName, String munitTest,
                                                String munitTags, Boolean skipAfterFailure,
                                                TargetRuntime targetRuntime,
                                                WorkingDirectoryGenerator workingDirectoryGenerator,
                                                File munitSrcFolder, MavenProject project,
                                                MavenSession session, Boolean clearParameters) {
    super(log, projectName, munitTest, munitTags, skipAfterFailure, targetRuntime, workingDirectoryGenerator, munitSrcFolder,
          project, session, clearParameters);
  }

  @Override
  protected ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder() {
    return new EmbeddedContainerConfiguration.EmbeddedContainerConfigurationBuilder()
        .withRuntimeId(getTargetRuntime().getRuntimeVersion())
        .withProduct(getTargetRuntime().getRuntimeProduct())
        .withMunitWorkingDirectoryPath(getWorkingDirectoryGenerator().generateWorkingDirectory().toFile().getAbsolutePath())
        .withLog4JConfigurationFilePath(getLog4JConfigurationFilePath())
        .withMavenConfiguration(getMavenConfigurationBuilder().build());
  }
}
