/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.locators.FilesLocator;

public class Log4J2ConfigurationLocator
implements FilesLocator {
    private static final String CLASSES_DIRECTORY = "classes";
    private static final String TEST_CLASSES_DIRECTORY = "test-classes";
    private static final String LOG4J2__FILE_NAME = "log4j2.xml";
    private static final String LOG4J2_TEST_FILE_NAME = "log4j2-test.xml";
    private Log log;

    public Log4J2ConfigurationLocator(Log log) {
        this.log = log;
    }

    @Override
    public List<File> locateFiles(File folder) {
        Path rootPath = Paths.get(folder.toURI());
        ArrayList<File> log4JFiles = new ArrayList<File>();
        Path configurationFilePath = rootPath.resolve(TEST_CLASSES_DIRECTORY).resolve(LOG4J2_TEST_FILE_NAME);
        if (configurationFilePath.toFile().exists()) {
            this.log.debug((CharSequence)("Located file at: " + configurationFilePath.toAbsolutePath().toString()));
            log4JFiles.add(configurationFilePath.toFile());
        }
        if ((configurationFilePath = rootPath.resolve(CLASSES_DIRECTORY).resolve(LOG4J2__FILE_NAME)).toFile().exists()) {
            this.log.debug((CharSequence)("Located file at: " + configurationFilePath.toAbsolutePath().toString()));
            log4JFiles.add(configurationFilePath.toFile());
        }
        if (log4JFiles.isEmpty()) {
            this.log.debug((CharSequence)"No file located");
        }
        return log4JFiles;
    }
}

