/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.mule.munit.plugin.maven.locators.JVMLocator;
import org.mule.munit.plugin.maven.locators.ProductVersionsLocator;
import org.mule.munit.plugin.maven.locators.RemoteRepositoriesLocator;
import org.mule.munit.plugin.maven.locators.TestSuiteFilesLocator;
import org.mule.munit.plugin.maven.runner.JVMStarter;
import org.mule.munit.plugin.maven.runner.MessageHandlerFactory;
import org.mule.munit.plugin.maven.runner.consumer.ErrorStreamConsumer;
import org.mule.munit.plugin.maven.runner.consumer.RunnerStreamConsumer;
import org.mule.munit.plugin.maven.runner.model.Debugger;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.DiscoverProduct;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.munit.plugin.maven.runtime.ProductConfiguration;
import org.mule.munit.plugin.maven.runtime.RuntimeConfiguration;
import org.mule.munit.plugin.maven.runtime.RuntimeProducts;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.ArgLinesManager;
import org.mule.munit.plugin.maven.util.ClasspathManager;
import org.mule.munit.plugin.maven.util.JarFileFactory;
import org.mule.munit.plugin.maven.util.MuleApplicationModelLoader;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.plugin.maven.util.RuntimeVersionProviderFactory;
import org.mule.munit.plugin.maven.util.properties.UserPropertiesBuilder;
import org.mule.munit.remote.RemoteRunner;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;

public abstract class AbstractMunitMojo
extends AbstractMojo {
    protected static final String ARG_TOKEN = "-";
    protected static final String RUN_CONFIGURATION_ARG = "-run_configuration";
    public static final String STARTER_CLASS_FILE = "munitstarter";
    public static final String MUNIT_PREVIOUS_RUN_PLACEHOLDER = "MUNIT_PREVIOUS_RUN_PLACEHOLDER";
    protected static final Class REMOTE_RUNNER_CLASS = RemoteRunner.class;
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    public static final String MULE_ARTIFACT_JSON_FILE_NAME = "mule-artifact.json";
    @Parameter(property="munit.test")
    public String munitTest;
    @Parameter(property="munit.tags")
    public String munitTags;
    @Parameter(property="munit.failIfNoTests", defaultValue="true")
    public boolean munitFailIfNoTests = true;
    @Parameter(property="munit.debug", defaultValue="false")
    public String munitDebug;
    @Parameter(property="runtimeVersion")
    public String runtimeVersion;
    @Parameter(property="runtimeProduct")
    public String runtimeProduct;
    @Parameter(defaultValue="${skipMunitTests}")
    public boolean skipMunitTests = false;
    @Parameter(defaultValue="false")
    public boolean clearParameters = false;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit")
    public File munitTestsDirectory;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit", readonly=true)
    public File defaultMunitTestsDirectory;
    @Parameter(property="project", required=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    public MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    public RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${plugin.artifactId}")
    public String pluginArtifactId;
    @Parameter(property="redirectTestOutputToFile", defaultValue="false")
    public boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/output/")
    public File testOutputDirectory;
    @Parameter(property="enableSurefireReports", defaultValue="true")
    public boolean enableSurefireReports;
    @Parameter(property="enableSonarReports", defaultValue="true")
    public boolean enableSonarReports;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    public File surefireReportsFolder;
    @Parameter(defaultValue="${project.build.directory}/sonar-reports/")
    public File sonarReportsFolder;
    @Parameter(property="skipAfterFailure", defaultValue="false")
    public boolean skipAfterFailure = false;
    @Parameter(property="munit.jvm")
    public String jvm;
    @Parameter(property="argLines")
    public List<String> argLines;
    @Parameter(property="system.property.variables")
    public Map<String, String> systemPropertyVariables;
    @Parameter(property="environment.variables")
    public Map<String, String> environmentVariables;
    @Parameter(property="dynamic.ports")
    public List<String> dynamicPorts;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    public boolean testFailureIgnore;
    @Deprecated
    @Parameter
    public RuntimeConfiguration runtimeConfiguration;
    @Parameter
    public ProductConfiguration productConfiguration;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected org.apache.maven.repository.RepositorySystem mavenRepositorySystem;
    @Parameter(property="project.build.directory", required=true)
    public File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    public ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    public List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.basedir}")
    public File projectBaseFolder;
    @Parameter
    public CloudHubDeployment cloudHubDeployment;
    protected Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public List<File> suiteFiles;
    public JVMLocator jvmLocator;
    public JarFileFactory jarFileFactory;
    public ClasspathManager classpathManager;
    public MessageHandlerFactory messageHandlerFactory;
    public Map<String, String> effectiveSystemProperties;
    public WorkingDirectoryGenerator workingDirectoryGenerator;
    public MuleApplicationModelLoader muleApplicationModelLoader;
    public RuntimeVersionProviderFactory runtimeVersionProviderFactory;
    public ProductVersionsLocator productVersionsLocator;
    public ResultPrinterFactory resultPrinterFactory;
    private String starterJarFileName = "";
    protected Debugger debugger;

    protected void init() throws MojoExecutionException {
        this.jarFileFactory = new JarFileFactory();
        this.starterJarFileName = org.mule.munit.common.util.FileUtils.generateRandomFileName((String)STARTER_CLASS_FILE, (String)".jar");
        this.messageHandlerFactory = new MessageHandlerFactory(this.getLog());
        this.validateProperties();
        this.effectiveSystemProperties = this.getEffectiveSystemProperties();
        this.jvmLocator = new JVMLocator(this.session, this.jvm, this.toolchainManager, this.getLog());
        this.workingDirectoryGenerator = new WorkingDirectoryGenerator(this.getLog(), this.getApplicationStructureGenerator(), this.project);
        this.classpathManager = new ClasspathManager(REMOTE_RUNNER_CLASS, this.getLog());
        this.muleApplicationModelLoader = this.getMuleApplicationModelLoader();
        this.resultPrinterFactory = this.getResultPrinterFactory();
        this.initConfiguration();
        this.runtimeVersionProviderFactory = new RuntimeVersionProviderFactory(this.repositorySystem, this.repositorySystemSession, this.createRemoteRepositoriesLocator(), this.getLog());
        this.productVersionsLocator = new ProductVersionsLocator(this.runtimeVersionProviderFactory, this.getLog());
        this.debugger = Debugger.fromString(this.munitDebug);
    }

    protected void initConfiguration() {
        this.productConfiguration = this.runtimeConfiguration != null ? ProductConfiguration.builder().from(this.productConfiguration).withRuntimeConfiguration(RuntimeConfiguration.builder().from(this.runtimeConfiguration).build()).withOverrides(this.session.getUserProperties()).build() : ProductConfiguration.builder().from(this.productConfiguration).withOverrides(this.session.getUserProperties()).build();
        this.runtimeConfiguration = null;
    }

    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!this.skipMunitTests) {
                if (!this.hasExecutedBefore()) {
                    if (this.hasSuites()) {
                        this.init();
                        this.doExecute();
                    } else {
                        this.getLog().warn((CharSequence)"MUnit will not run, no MUnit suites found in your project");
                    }
                } else {
                    this.getLog().info((CharSequence)"Skipping execution of munit because it has already been run");
                }
            } else {
                this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_MUNIT_TESTS_PROPERTY));
            }
        } else {
            this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_TESTS_PROPERTY));
        }
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(MUNIT_PREVIOUS_RUN_PLACEHOLDER)) {
            return true;
        }
        this.getPluginContext().put(MUNIT_PREVIOUS_RUN_PLACEHOLDER, MUNIT_PREVIOUS_RUN_PLACEHOLDER);
        return false;
    }

    public void doExecute() throws MojoExecutionException {
        Map<TargetProduct, RunConfiguration> runConfigurations = this.getRunConfigurations();
        TreeMap<TargetProduct, RunResult> runResults = new TreeMap<TargetProduct, RunResult>();
        try {
            for (Map.Entry<TargetProduct, RunConfiguration> runConfigurationEntry : runConfigurations.entrySet()) {
                RunConfiguration runConfiguration = runConfigurationEntry.getValue();
                this.workingDirectoryGenerator.generate(runConfiguration);
                TargetProduct targetProduct = runConfigurationEntry.getKey();
                this.getLog().info((CharSequence)String.format("Running %s with version %s", new Object[]{targetProduct.getProduct(), targetProduct.getVersion()}));
                if (runConfiguration.getSuitePaths().isEmpty()) {
                    if (this.munitFailIfNoTests) {
                        throw new MojoExecutionException("No tests suites were found! (Set -Dmunit.failIfNoTests=false to ignore this error.)");
                    }
                    this.getLog().info((CharSequence)"No MUnit test suite files found. No test will be run");
                    return;
                }
                RunnerStreamConsumer streamConsumer = new RunnerStreamConsumer(this.messageHandlerFactory.create(this.redirectTestOutputToFile));
                streamConsumer.setRunConfiguration(runConfiguration);
                ErrorStreamConsumer errorStreamConsumer = new ErrorStreamConsumer(this.redirectTestOutputToFile);
                int result = this.createTestRunExecutor(runConfiguration).execute(streamConsumer, (StreamConsumer)errorStreamConsumer);
                if (result == 0) {
                    RunResult runResult = streamConsumer.getRunResult();
                    runResults.put(targetProduct, runResult);
                    continue;
                }
                throw new MojoExecutionException("Build Failed", (Exception)new MojoExecutionException(errorStreamConsumer.getOutput()));
            }
            runResults.forEach(this::handleRunResult);
            this.failBuildIfNecessary(runResults);
        }
        catch (IOException | CommandLineException e) {
            throw new MojoExecutionException("Build Failed", (Exception)e);
        }
    }

    protected JVMStarter createTestRunExecutor(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = this.saveRunConfigurationToFile(runConfiguration);
        File log4jConfigurationFile = new File(runConfiguration.getContainerConfiguration().getLog4JConfigurationFilePath());
        return this.createJVMStarter(runConfigurationFile, this.getEffectiveArgLines(this.starterJarFileName, log4jConfigurationFile));
    }

    protected void handleRunResult(TargetProduct targetProduct, RunResult runResult) {
        for (ResultPrinter printer : this.resultPrinterFactory.create()) {
            printer.print(targetProduct, runResult);
        }
    }

    protected void failBuildIfNecessary(Map<TargetProduct, RunResult> runResults) throws MojoExecutionException {
        if (runResults.values().stream().anyMatch(RunResult::finishedWithErrors)) {
            throw new MojoExecutionException("There was an error running MUnit tests");
        }
        if (!this.testFailureIgnore && runResults.values().stream().anyMatch(RunResult::hasFailed)) {
            throw new MojoExecutionException("MUnit Tests Failed");
        }
        if (this.munitFailIfNoTests && runResults.values().stream().allMatch(result -> result.getNumberOfTests() == 0)) {
            throw new MojoExecutionException("No tests were executed! (Set -Dmunit.failIfNoTests=false to ignore this error.)");
        }
    }

    protected abstract ResultPrinterFactory getResultPrinterFactory();

    protected abstract ApplicationStructureGenerator getApplicationStructureGenerator() throws MojoExecutionException;

    protected abstract File getMuleApplicationJsonPath();

    protected abstract RunConfiguration createRunConfiguration(TargetProduct var1) throws MojoExecutionException;

    protected Map<TargetProduct, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        TreeMap<TargetProduct, RunConfiguration> runConfigurations = new TreeMap<TargetProduct, RunConfiguration>();
        ArrayList<TargetProduct> effectiveTargetRuntimes = new ArrayList<TargetProduct>();
        if (this.shouldRunSingleRuntime()) {
            this.addDefaultTargetProducts(effectiveTargetRuntimes);
        } else {
            List<String> additionalProducts = this.productConfiguration.getAdditionalProducts();
            List productsToDiscover = this.productConfiguration.getDiscoverProducts().stream().filter(discoverProduct -> this.cloudHubDeployment == null && !discoverProduct.isSkipped()).collect(Collectors.toList());
            if (additionalProducts != null && !additionalProducts.isEmpty()) {
                effectiveTargetRuntimes.addAll(additionalProducts.stream().map(TargetProduct::parse).collect(Collectors.toList()));
            }
            if (!productsToDiscover.isEmpty()) {
                for (DiscoverProduct discoverProduct2 : productsToDiscover) {
                    effectiveTargetRuntimes.addAll(this.discoverProducts(this.muleApplicationModelLoader.getRuntimeVersion(), discoverProduct2));
                }
            } else {
                this.addDefaultTargetProducts(effectiveTargetRuntimes);
            }
        }
        for (TargetProduct targetRuntime : effectiveTargetRuntimes) {
            RunConfiguration runConfiguration = this.createRunConfiguration(targetRuntime);
            runConfigurations.put(targetRuntime, runConfiguration);
        }
        return runConfigurations;
    }

    private boolean shouldRunSingleRuntime() {
        return this.runtimeVersion != null || this.runtimeProduct != null;
    }

    private Set<TargetProduct> discoverProducts(String version, DiscoverProduct discoverProduct) throws MojoExecutionException {
        Product product = discoverProduct.getProductId().orElseThrow(() -> new MojoExecutionException(String.format("Invalid Product Configuration: the auto discovery of products was enabled but no product kind was specified, neither in the plugin nor using the command line argument '%s'. One of the following products has to be selected: %s", "discoverProducts.product", Arrays.asList(Product.values()))));
        if (this.muleApplicationModelLoader.getRuntimeProduct().equals(RuntimeProducts.EE.value()) && !product.supportsEe()) {
            throw new MojoExecutionException(String.format("Product is EE only but was configured to discover %s runtimes.", product.name()));
        }
        this.productVersionsLocator.includingSnapshots(discoverProduct.isIncludeSnapshots()).withMinVersion(discoverProduct.getMinVersion().orElse(version)).withProduct(product).usingLatestPatches(discoverProduct.isUseLatestPatches());
        return this.productVersionsLocator.locate();
    }

    private void addDefaultTargetProducts(List<TargetProduct> effectiveTargetProducts) {
        effectiveTargetProducts.add(new TargetProduct(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct().equals("MULE") ? Product.MULE_CE : Product.MULE_EE));
    }

    public List<String> getEffectiveArgLines(String starterJarFileName, File log4jConfigurationFile) {
        if (!Optional.ofNullable(this.debugger).map(Debugger::getAddDebugger).orElse(false).booleanValue()) {
            return new ArgLinesManager(this.argLines, starterJarFileName, this.munitDebug, log4jConfigurationFile, this.getLog()).getEffectiveArgLines();
        }
        List<String> effectiveArgLines = new ArgLinesManager(this.argLines, starterJarFileName, null, log4jConfigurationFile, this.getLog()).getEffectiveArgLines();
        return Stream.concat(effectiveArgLines.stream(), this.debugger.getArguments().stream()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public JVMStarter createJVMStarter(File runConfigurationFile, List<String> argLines) throws IOException {
        this.getLog().debug((CharSequence)("MUnit root folder found at: " + this.munitTestsDirectory.getAbsolutePath()));
        File jarFile = this.jarFileFactory.create(this.classpathManager.getEffectiveClasspath(), REMOTE_RUNNER_CLASS.getCanonicalName(), new File(this.project.getBuild().getDirectory()), this.starterJarFileName);
        JVMStarter jvmStarter = new JVMStarter(this.getLog()).withJVM(this.jvmLocator.locate()).withWorkingDirectory(this.getWorkingDirectory()).withJar(jarFile).withArgLines(argLines).withSystemProperties(this.effectiveSystemProperties).addEnvironmentVariables(this.environmentVariables);
        HashMap<String, File> fileArgLines = new HashMap<String, File>();
        fileArgLines.put(RUN_CONFIGURATION_ARG, runConfigurationFile);
        jvmStarter.withArgLines(fileArgLines);
        String javaVersion = jvmStarter.getVersion();
        if (javaVersion != null && (javaVersion.startsWith("11") || javaVersion.startsWith("17"))) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--add-opens=java.base/java.lang=org.mule.runtime.jpms.utils");
            jvmStarter.withArgLines(args);
        }
        return jvmStarter;
    }

    public File saveRunConfigurationToFile(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = Paths.get(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), "run-configuration.json").toFile();
        this.saveAsJsonDataToFile(runConfiguration, runConfigurationFile);
        return runConfigurationFile;
    }

    protected void saveAsJsonDataToFile(Object data, File dataLocation) {
        try {
            if (dataLocation == null) {
                this.getLog().warn((CharSequence)"Unable to save data, no destination file was provided");
                return;
            }
            dataLocation.getParentFile().mkdirs();
            dataLocation.createNewFile();
            org.mule.munit.common.util.FileUtils.writeStringToFile((File)dataLocation, (String)this.gson.toJson(data), (Charset)Charset.defaultCharset());
            this.getLog().debug((CharSequence)("Data File saved in " + dataLocation));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to save data to file:" + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
    }

    protected MuleApplicationModelLoader getMuleApplicationModelLoader() throws MojoExecutionException {
        return new MuleApplicationModelLoader(this.getMuleApplicationModel(), this.getLog()).withRuntimeProduct(this.runtimeProduct).withRuntimeVersion(this.runtimeVersion);
    }

    protected MuleApplicationModel getMuleApplicationModel() throws MojoExecutionException {
        File muleApplicationJsonPath = this.getMuleApplicationJsonPath();
        try {
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleApplicationJsonPath, (Charset)Charset.defaultCharset()));
        }
        catch (IOException e) {
            String message = "Fail to read mule application file from " + muleApplicationJsonPath;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    public File getWorkingDirectory() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return new File(".");
    }

    private Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        effectiveSystemProperties.putAll(this.getUserSystemProperties());
        effectiveSystemProperties.put("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        return effectiveSystemProperties;
    }

    private Map<String, String> getUserSystemProperties() {
        UserPropertiesBuilder builder = new UserPropertiesBuilder(this.project.getBuild().getDirectory(), this.getLog()).withSystemPropertyVariables(this.systemPropertyVariables).withDynamicPorts(this.dynamicPorts).withUserProperties(this.session != null ? this.session.getUserProperties() : null);
        Deployment deployment = this.getDeployments().stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (deployment != null && deployment instanceof AnypointDeployment) {
            AnypointDeployment anypointDeployment = (AnypointDeployment)deployment;
            builder.withUserCredentials(anypointDeployment.getUsername(), anypointDeployment.getPassword());
        }
        return builder.build();
    }

    private boolean hasSuites() {
        this.suiteFiles = new TestSuiteFilesLocator().locateFiles(this.munitTestsDirectory);
        return !this.suiteFiles.isEmpty();
    }

    protected RemoteRepositoriesLocator createRemoteRepositoriesLocator() {
        return new RemoteRepositoriesLocator(this.project);
    }

    public List<Deployment> getDeployments() {
        return Arrays.asList(this.cloudHubDeployment);
    }

    public void validateProperties() throws MojoExecutionException {
        if (!org.mule.munit.common.util.FileUtils.isInDirectory((File)this.defaultMunitTestsDirectory, (File)this.munitTestsDirectory)) {
            throw new MojoExecutionException("munitTestsDirectory property must be a subfolder of ${project.build.directory}/test-mule/munit.");
        }
        if (this.cloudHubDeployment == null) {
            return;
        }
        if (this.dynamicPorts != null && !this.dynamicPorts.isEmpty()) {
            throw new MojoExecutionException("DynamicPorts defined in the pom file do not work on CloudHub. Use munit:dynamic-port instead.");
        }
        if (this.environmentVariables != null && !this.environmentVariables.isEmpty()) {
            this.getLog().warn((CharSequence)"Environment variables will work as a placeholder properties when run on CloudHub. No OS environment properties will be set.");
        }
    }
}

