/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class ArgLinesManager {
    public static final String JAVA_SYSTEM_CLASS_LOADER = "java.system.class.loader";
    private static final List<String> INVALID_ARG_LINES = Arrays.asList("-jar", "-cp", "-classpath", "-Dmunit.classloader.starter.jar.file.name", "-Djava.system.class.loader");
    public static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String DEFAULT_DEBUG_ARG_LINE = "-agentlib:jdwp=transport=dt_socket,server=y,address=5005,suspend=y";
    private Log log;
    private String starterJarFileName;
    private String debuggerArgLine;
    private File log4jConfiguration;
    private List<String> originalArgLines;

    public ArgLinesManager(List<String> originalArgLines, String starterJarFileName, String debuggerArgLine, File log4jConfiguration, Log log) {
        this.originalArgLines = originalArgLines;
        this.starterJarFileName = starterJarFileName;
        this.log4jConfiguration = log4jConfiguration;
        this.debuggerArgLine = debuggerArgLine;
        this.log = log;
    }

    public List<String> getEffectiveArgLines() {
        ArrayList<String> effectiveArgLines = new ArrayList<String>();
        for (String argLine : this.originalArgLines) {
            if (this.filterArgLine(argLine)) {
                this.log.warn((CharSequence)(argLine + " can not be set. We will ignore this argLine"));
                continue;
            }
            effectiveArgLines.add(argLine);
        }
        this.addDefaultArgLines(effectiveArgLines);
        this.addDebuggerArgLine(effectiveArgLines);
        this.addLog4jConfigurationFile(effectiveArgLines);
        if (System.getProperty("java.version").startsWith("17") || System.getProperty("java.version").startsWith("11")) {
            effectiveArgLines.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        }
        return effectiveArgLines;
    }

    private boolean filterArgLine(String argLine) {
        if (StringUtils.isBlank((CharSequence)argLine)) {
            return true;
        }
        for (String invalidArgLine : INVALID_ARG_LINES) {
            if (!argLine.startsWith(invalidArgLine)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultArgLines(List<String> effectiveArgLines) {
        effectiveArgLines.add("-Dmunit.classloader.starter.jar.file.name=" + this.starterJarFileName);
    }

    private void addDebuggerArgLine(List<String> effectiveArgLines) {
        if ("true".equalsIgnoreCase(this.debuggerArgLine)) {
            effectiveArgLines.add(DEFAULT_DEBUG_ARG_LINE);
        } else if (!"false".equalsIgnoreCase(this.debuggerArgLine) && StringUtils.isNotBlank((CharSequence)this.debuggerArgLine)) {
            effectiveArgLines.add(this.debuggerArgLine);
        }
    }

    private void addLog4jConfigurationFile(List<String> effectiveArgLines) {
        if (this.log4jConfiguration.exists()) {
            effectiveArgLines.add("-Dlog4j.configurationFile=" + this.log4jConfiguration.getAbsolutePath());
        }
    }
}

