/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util;

import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.remote.api.configuration.CloudHubContainerConfiguration;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;

import java.io.File;
import java.util.Map;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/**
 * Creates {@link RunConfiguration} based on basic MUnit parameters for CloudHub
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class BaseCloudHubRunConfigurationFactory extends BaseRunConfigurationFactory {

  private final CloudHubDeployment deployment;
  private final Map<String, String> systemPropertyVariables;
  private final Map<String, String> environmentVariables;
  private final boolean debugEnabled;
  private final String executionId;

  public BaseCloudHubRunConfigurationFactory(Log log, String projectName, String munitTest, String munitTags,
                                             Boolean skipAfterFailure, TargetProduct targetProduct,
                                             WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder,
                                             MavenProject project, MavenSession session, Deployment deployment,
                                             Map<String, String> systemPropertyVariables,
                                             Map<String, String> environmentVariables, String executionId,
                                             Boolean clearParameters) {
    super(log, projectName, munitTest, munitTags, skipAfterFailure, targetProduct, workingDirectoryGenerator, munitSrcFolder,
          project, session, clearParameters);

    this.deployment = (CloudHubDeployment) deployment;
    this.systemPropertyVariables = systemPropertyVariables;
    this.environmentVariables = environmentVariables;
    this.debugEnabled = log.isDebugEnabled();
    this.executionId = executionId;
  }

  @Override
  protected ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder() {
    return new CloudHubContainerConfiguration.CloudHubContainerConfigurationBuilder()
        .withDeploymentConfiguration(deployment)
        .withMunitWorkingDirectoryPath(getWorkingDirectoryGenerator().generateWorkingDirectory().toFile().getAbsolutePath())
        .withLog4JConfigurationFilePath(getLog4JConfigurationFilePath())
        .withExecutionId(executionId)
        .withSystemPropertyVariables(systemPropertyVariables)
        .withEnvironmentVariables(environmentVariables)
        .withDebugEnabled(debugEnabled);
  }
}
