/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.model;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;
import org.mule.munit.plugin.maven.runner.model.TestResult;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;

public class RunResult {
    private SuiteResult currentSuite = null;
    private String stackTrace = "";
    private ApplicationCoverageReport coverageReport;
    private Map<String, List<String>> suiteOutputs = Collections.emptyMap();
    private boolean runFinished = false;
    private boolean coverageEnabled = true;
    private boolean unexpectedError = false;
    private boolean runtimeStartFailed = false;
    private Map<String, SuiteResult> suites = new HashMap<String, SuiteResult>();

    public void containerStartFailed(String stackTrace) {
        this.runtimeStartFailed = true;
        this.stackTrace = stackTrace;
    }

    public void testSuiteStartFailed(String suitePath, String parameterization, String stackTrace) {
        SuiteResult suite = new SuiteResult();
        suite.setSuitePath(suitePath);
        suite.setParameterization(parameterization);
        suite.setRuntimeStartFailed(true);
        suite.setCause(stackTrace);
        this.suites.put(this.getSuiteId(suitePath, parameterization), suite);
    }

    public void testSuiteStarted(String suiteFullPath, String parameterization) {
        SuiteResult suite = new SuiteResult();
        suite.setSuitePath(suiteFullPath);
        suite.setParameterization(parameterization);
        this.suites.put(this.getSuiteId(suiteFullPath, parameterization), suite);
        this.currentSuite = suite;
    }

    public void testStarted(String testName) {
        this.currentSuite.add(testName, new TestResult(testName));
    }

    public void testFailure(String testName, String stackTrace, long elapsedTime) {
        TestResult test = this.getOrCreateTest(testName);
        test.setFailed(true);
        test.setCause(stackTrace);
        test.setTime(elapsedTime);
    }

    public void testError(String testName, String stackTrace, long elapsedTime) {
        TestResult test = this.getOrCreateTest(testName);
        test.setError(true);
        test.setCause(stackTrace);
        test.setTime(elapsedTime);
    }

    public void testFinished(String testName, long elapsedTime) {
        TestResult test = this.getOrCreateTest(testName);
        test.setFinished(true);
        test.setTime(elapsedTime);
    }

    public void testIgnored(String testName, long elapsedTime) {
        TestResult test = this.getOrCreateTest(testName);
        test.setIgnored(true);
        test.setTime(elapsedTime);
    }

    public void addSuite(SuiteResult result) {
        this.suites.put(result.getSuitePath(), result);
    }

    public void suiteFinished(long elapsedTime) {
        this.currentSuite.setSuiteFinished(true);
        this.currentSuite.setTime(elapsedTime);
        this.currentSuite = null;
    }

    public void suiteFailure(String stackTrace) {
        this.currentSuite.setSuiteFailed(true);
        this.currentSuite.setCause(stackTrace);
    }

    public void suiteError(String stackTrace) {
        this.currentSuite.setSuiteError(true);
        this.currentSuite.setCause(stackTrace);
    }

    public void testSuiteUnexpectedError(String suiteFullPath, String stackTrace) {
        SuiteResult suite = new SuiteResult();
        suite.setSuitePath(suiteFullPath);
        suite.setSuiteError(true);
        suite.setCause(stackTrace);
        this.suites.put(suiteFullPath, suite);
        this.currentSuite = null;
    }

    public void unexpectedError(String stackTrace) {
        this.currentSuite = null;
        this.unexpectedError = true;
        this.runFinished = true;
        this.stackTrace = stackTrace;
    }

    public Collection<SuiteResult> getSuites() {
        return this.suites.values();
    }

    public boolean isRunFinished() {
        return this.runFinished;
    }

    public void setRunFinished(boolean runFinished) {
        this.runFinished = runFinished;
    }

    public SuiteResult getSuite(String suitePath, String parameterization) {
        return this.suites.get(this.getSuiteId(suitePath, parameterization));
    }

    public int getNumberOfTests() {
        return this.summarize(SuiteResult::getNumberOfTests);
    }

    public int getNumberOfIgnores() {
        return this.summarize(SuiteResult::getNumberOfIgnores);
    }

    public int getNumberOfErrors() {
        return this.summarize(SuiteResult::getNumberOfErrors);
    }

    public int getNumberOfFailures() {
        return this.summarize(SuiteResult::getNumberOfFailures);
    }

    private int summarize(ToIntFunction<SuiteResult> predicate) {
        return this.getSuites().stream().mapToInt(predicate).sum();
    }

    public SuiteResult getCurrentSuite() {
        return this.currentSuite;
    }

    public Optional<ApplicationCoverageReport> getApplicationCoverageReport() {
        return Optional.ofNullable(this.coverageReport);
    }

    public void setCoverageReport(ApplicationCoverageReport report) {
        this.coverageReport = report;
    }

    public void setCoverageReport(String jsonReport) {
        this.coverageReport = (ApplicationCoverageReport)new Gson().fromJson(jsonReport, ApplicationCoverageReport.class);
    }

    public Map<String, List<String>> getSuiteOutputs() {
        return this.suiteOutputs;
    }

    public void setSuiteOutputs(Map<String, List<String>> suiteOutputs) {
        this.suiteOutputs = suiteOutputs;
    }

    public boolean hasFailed() {
        return this.finishedWithErrors() || this.suites.values().stream().anyMatch(suite -> suite.hasFailed() || suite.hasError());
    }

    public boolean finishedWithErrors() {
        return this.unexpectedError || this.runtimeStartFailed;
    }

    public void setCoverageEnabled(boolean runCoverage) {
        this.coverageEnabled = runCoverage;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isRuntimeStartFailed() {
        return this.runtimeStartFailed;
    }

    private String getSuiteId(String suitePath, String parameterization) {
        return suitePath + "|" + parameterization;
    }

    private TestResult getOrCreateTest(String testName) {
        TestResult test = this.currentSuite.getTest(testName);
        if (test == null) {
            TestResult testResult = new TestResult(testName);
            this.currentSuite.add(testName, testResult);
            return testResult;
        }
        return test;
    }
}

