/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Debugger {
    private final Boolean addDebugger;
    private final Type type;
    private final Integer debuggerPort;
    private final String debuggerVersion;
    private final String lockId;
    private final Boolean withDebug;

    public static Debugger fromString(String value) {
        String[] values;
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)value)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = values = value.split(":");
        }
        if (!"ACBDebugger".equals(values[0])) {
            return new Debugger(false, null, 0, "", null, false);
        }
        if (values.length < 2 || StringUtils.isEmpty((CharSequence)values[1])) {
            throw new IllegalArgumentException("A lockId is required");
        }
        int debuggerPort = values.length < 3 || StringUtils.isBlank((CharSequence)values[2]) ? 4555 : Integer.parseInt(values[2]);
        String debuggerVersion = values.length < 4 || StringUtils.isBlank((CharSequence)values[3]) ? "1.0.25" : values[3];
        boolean withDebug = values.length >= 5 && Boolean.parseBoolean(values[4]);
        return new Debugger(true, Type.ANYPOINT_CODE_BUILDER, debuggerPort, debuggerVersion, values[1], withDebug);
    }

    public Debugger(Boolean addDebugger, Type type, Integer debuggerPort, String debuggerVersion, String lockId, Boolean withDebug) {
        this.addDebugger = addDebugger;
        this.type = type;
        this.debuggerPort = debuggerPort;
        this.debuggerVersion = debuggerVersion;
        this.lockId = lockId;
        this.withDebug = withDebug;
    }

    public Boolean getAddDebugger() {
        return this.addDebugger;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getDebuggerPort() {
        return this.debuggerPort;
    }

    public String getDebuggerVersion() {
        return this.debuggerVersion;
    }

    public List<String> getArguments() {
        if (!this.addDebugger.booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("-Dmule.debug.port=" + this.debuggerPort);
        values.add("-DACBDebugger=true");
        if (this.withDebug.booleanValue()) {
            values.add("-agentlib:jdwp=transport=dt_socket,server=y,address=5005,suspend=y");
        }
        return Collections.unmodifiableList(values);
    }

    public String getLockId() {
        return this.lockId;
    }

    public Boolean getWithDebug() {
        return this.withDebug;
    }

    public static enum Type {
        ANYPOINT_CODE_BUILDER;

    }
}

