/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.api.configuration.RunConfiguration;

public class TestSuiteFileFilter {
    private static final String SINGLE_TEST_NAME_TOKEN = "#";
    private static final String TEST_DELIMITER = ",";
    private final Log log;
    private List<String> testSuiteRegEx = new ArrayList<String>();
    private List<RunConfiguration.Test> testNameRegEx = new ArrayList<RunConfiguration.Test>();

    public TestSuiteFileFilter(Log log, String filter) {
        Preconditions.checkNotNull((Object)log, (String)"The log must not be null");
        this.log = log;
        if (StringUtils.isNotBlank((CharSequence)filter) && StringUtils.countMatches((CharSequence)filter, (CharSequence)SINGLE_TEST_NAME_TOKEN) == 1) {
            String suite = filter.substring(0, filter.indexOf(SINGLE_TEST_NAME_TOKEN));
            this.testSuiteRegEx.add(suite);
            for (String test : filter.substring(filter.indexOf(SINGLE_TEST_NAME_TOKEN) + 1).split(TEST_DELIMITER)) {
                this.testNameRegEx.add(RunConfiguration.Test.of((String)suite, (String)test));
            }
        } else if (StringUtils.isNotBlank((CharSequence)filter) && StringUtils.countMatches((CharSequence)filter, (CharSequence)SINGLE_TEST_NAME_TOKEN) > 1) {
            for (String test : filter.split(TEST_DELIMITER)) {
                this.testSuiteRegEx.add(test.substring(0, test.indexOf(SINGLE_TEST_NAME_TOKEN)));
                this.testNameRegEx.add(RunConfiguration.Test.of((String)test.substring(0, test.indexOf(SINGLE_TEST_NAME_TOKEN)), (String)test.substring(test.indexOf(SINGLE_TEST_NAME_TOKEN) + 1)));
            }
        } else {
            this.testSuiteRegEx.add(filter);
        }
    }

    public List<RunConfiguration.Test> getTestNameRegEx() {
        return this.testNameRegEx;
    }

    public boolean shouldFilter(String fileName) {
        boolean result;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileName), (String)"The fileName should not be null nor empty");
        if (this.testSuiteRegEx.stream().anyMatch(suite -> StringUtils.isNotBlank((CharSequence)suite)) && !(result = this.testSuiteRegEx.stream().anyMatch(suite -> fileName.matches((String)suite)))) {
            this.log.debug((CharSequence)("MUnit Test Suite file " + fileName + " skipped. It doesn't match filter criteria: [" + this.testSuiteRegEx + "]"));
            return false;
        }
        return true;
    }
}

