/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util.properties;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

/**
 * <p>
 * Saves properties to a file
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public abstract class PropertiesFileBuilder {

  private String propertiesFileFolderPath;
  protected Log log;

  public PropertiesFileBuilder(String propertiesFileFolderPath, Log log) {
    this.propertiesFileFolderPath = propertiesFileFolderPath;
    this.log = log;
  }

  public Map<String, String> savePropertiesFileIfRequired(Map<String, String> effectiveSystemProperties) {
    if (StringUtils.isNotBlank(propertiesFileFolderPath)) {
      try {
        String propertiesFilePath = propertiesFileFolderPath + File.separator + getFileName();
        savePropertiesFile(effectiveSystemProperties, propertiesFileFolderPath, getFileName());

        Map<String, String> fileSystemProperties = new HashMap<>();
        setSystemPropertiesFile(propertiesFilePath, fileSystemProperties);
        return fileSystemProperties;
      } catch (IOException e) {
        log.error("Fail to save " + getFileName() + " sending properties as parameter", e);
      }
    } else {
      log.error("Save system properties to file disabled");
    }

    return effectiveSystemProperties;
  }

  private void savePropertiesFile(Map<String, String> propertiesMap, String path, String name) throws IOException {
    Properties props = new Properties();

    propertiesMap.entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue()))
        .forEach(entry -> props.setProperty(entry.getKey(), entry.getValue()));

    File file = new File(path, name);
    OutputStream out = new FileOutputStream(file);
    props.store(out, "");
    out.close();
    file.deleteOnExit();
  }

  private void setSystemPropertiesFile(String systemPropertiesFile, Map<String, String> props) {
    log.debug(String.format("Setting [%s] to %s", getFileProperty(), systemPropertiesFile));
    props.put(getFileProperty(), systemPropertiesFile);
  }

  protected abstract String getFileProperty();

  protected abstract String getFileName();

}
