/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.runtime.api.meta.MuleVersion;

public class TargetProduct
implements Comparable<TargetProduct> {
    private static final String TARGET_PRODUCT_SEPARATOR = ":";
    private final MuleVersion version;
    private final Product product;

    public TargetProduct(String version, Product product) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)version), (String)"Version cannot be blank");
        this.version = new MuleVersion(version);
        Objects.requireNonNull(product, "Product cannot be blank");
        this.product = product;
    }

    public static TargetProduct parse(String targetProduct) {
        String[] versionAndProduct = StringUtils.split((String)targetProduct, (String)TARGET_PRODUCT_SEPARATOR);
        if (versionAndProduct.length != 2) {
            throw new IllegalArgumentException("Target product should be in the form of <product>:<version>. For example MULE_EE:4.1.1");
        }
        String product = versionAndProduct[0];
        String version = versionAndProduct[1];
        return new TargetProduct(version, Product.valueOf(product));
    }

    public Product getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetProduct that = (TargetProduct)o;
        return this.version.equals((Object)that.version) && this.product.equals((Object)that.product);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (Object)((Object)this.product) + TARGET_PRODUCT_SEPARATOR + this.version.toString();
    }

    @Override
    public int compareTo(TargetProduct that) {
        if (that == null) {
            throw new NullPointerException("Can't compare against null");
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.product.ordinal() == that.product.ordinal()) {
            return this.version.newerThan(that.version) ? 1 : -1;
        }
        return this.product.ordinal() - that.product.ordinal();
    }
}

