/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.meta.MuleVersion;

public class MuleApplicationModelLoader {
    private static final Pattern VERSION_PATTERN = Pattern.compile("support-tools-installer-\\d.\\d{1,2}.\\d{1,2}(-(SNAPSHOT|\\d+))?");
    public static final MuleVersion MIN_MULE_GA_VERSION = new MuleVersion("4.1.1");
    private final MuleApplicationModel muleApplicationModel;
    private String runtimeVersion;
    private String runtimeProduct;
    private String runtimeLocalDistribution;
    private final Log log;

    public MuleApplicationModelLoader(MuleApplicationModel muleApplicationModel, Log log) {
        this.muleApplicationModel = muleApplicationModel;
        this.log = log;
    }

    public MuleApplicationModelLoader withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public MuleApplicationModelLoader withRuntimeProduct(String runtimeProduct) {
        this.runtimeProduct = runtimeProduct;
        return this;
    }

    public MuleApplicationModelLoader withRuntimeLocalDistribution(String runtimeLocalDistribution) {
        this.runtimeLocalDistribution = runtimeLocalDistribution;
        return this;
    }

    public String getRuntimeVersion() throws MojoExecutionException, IOException {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeLocalDistribution)) {
            return this.getVersionFromLocalDistribution(this.runtimeLocalDistribution);
        }
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        String runtimeVersion = this.getMinMuleVersion();
        this.log.debug((CharSequence)("Runtime version set to " + runtimeVersion + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeVersion;
    }

    public String getRuntimeProduct() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeProduct)) {
            return this.runtimeProduct;
        }
        String runtimeProduct = this.muleApplicationModel.getRequiredProduct().name();
        this.log.debug((CharSequence)("Runtime product set to " + runtimeProduct + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeProduct;
    }

    private String getMinMuleVersion() {
        MuleVersion minMuleVersion = new MuleVersion(this.muleApplicationModel.getMinMuleVersion());
        if (minMuleVersion.atLeast(MIN_MULE_GA_VERSION)) {
            return this.muleApplicationModel.getMinMuleVersion();
        }
        return MIN_MULE_GA_VERSION.toCompleteNumericVersion();
    }

    private String getVersionFromLocalDistribution(String path) throws MojoExecutionException, IOException {
        String message = "'" + path + "' is not a valid standalone mule distribution";
        File file = new File(path);
        if (!file.exists() || file.isFile()) {
            throw new MojoExecutionException(message);
        }
        File version = new File(file, "version.txt");
        if (version.exists() && version.isFile()) {
            return IOUtils.toString((Reader)new FileReader(version));
        }
        File tools = new File(file, "tools");
        if (!tools.exists() || tools.isFile()) {
            throw new MojoExecutionException(message);
        }
        return Stream.of(Objects.requireNonNull(tools.list())).map(fileName -> {
            Matcher matcher = VERSION_PATTERN.matcher((CharSequence)fileName);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group(0).substring(24);
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new MojoExecutionException(message));
    }
}

