/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runner.consumer;


import org.apache.maven.shared.utils.cli.CommandLineUtils;

/**
 * <p>
 * A Stream Consumer that stores the Error Standard Output
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ErrorStreamConsumer extends CommandLineUtils.StringStreamConsumer {

  private boolean redirectTestOutputToFile = false;

  public ErrorStreamConsumer(boolean redirectTestOutputToFile) {
    this.redirectTestOutputToFile = redirectTestOutputToFile;
  }

  @Override
  public void consumeLine(String line) {
    super.consumeLine(line);
    if (!redirectTestOutputToFile) {
      System.out.println(line);
    }
  }
}
