/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runtime;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;

/**
 * <p>
 * Encapsulates Product and Version for Mule runtimes
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.2.0
 */
public class Target {

  TargetProduct product;
  ArtifactVersion version;

  public Target(TargetProduct product, ArtifactVersion version) {
    this.product = product;
    this.version = version;
  }

  public ArtifactVersion getVersion() {
    return version;
  }

  public void setVersion(ArtifactVersion version) {
    this.version = version;
  }

  public TargetProduct getProduct() {
    return product;
  }

  public void setProduct(TargetProduct product) {
    this.product = product;
  }
}
