/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runtime;

import org.mule.runtime.api.meta.MuleVersion;

/**
 * Indicates which products to discover
 *
 * @author Mulesoft Inc.
 * @since 2.4.0
 */
public enum Product {

  MULE_CE(true, false, false, new MuleVersion("4.1.1"), org.mule.runtime.module.embedded.api.Product.MULE),

  MULE_EE(false, true, false, new MuleVersion("4.1.1"), org.mule.runtime.module.embedded.api.Product.MULE_EE),

  MULE_FWK(true, true, true, null, org.mule.runtime.module.embedded.api.Product.MULE_FRAMEWORK);

  private boolean supportsCe;
  private boolean supportsEe;
  private boolean supportsOnlyTooling;
  private MuleVersion minVersion;
  private org.mule.runtime.module.embedded.api.Product embeddedProduct;

  Product(boolean supportsCe, boolean supportsEe, boolean supportsOnlyTooling, MuleVersion minVersion,
          org.mule.runtime.module.embedded.api.Product embeddedProduct) {
    this.supportsCe = supportsCe;
    this.supportsEe = supportsEe;
    this.supportsOnlyTooling = supportsOnlyTooling;
    this.minVersion = minVersion;
    this.embeddedProduct = embeddedProduct;
  }

  public boolean supportsCe() {
    return supportsCe;
  }

  public boolean supportsEe() {
    return supportsEe;
  }

  public boolean supportsOnlyTooling() {
    return supportsOnlyTooling;
  }

  public MuleVersion getMinVersion() {
    return minVersion;
  }

  public org.mule.runtime.module.embedded.api.Product getEmbeddedProduct() {
    return embeddedProduct;
  }
}
