/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.skuzzle.semantic.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.mule.munit.plugin.maven.fips.FipsArgumentsResolver;
import org.mule.munit.plugin.maven.locators.JVMLocator;
import org.mule.munit.plugin.maven.locators.ProductVersionsLocator;
import org.mule.munit.plugin.maven.locators.RemoteRepositoriesLocator;
import org.mule.munit.plugin.maven.locators.TestSuiteFilesLocator;
import org.mule.munit.plugin.maven.project.ApplicationStructureGenerator;
import org.mule.munit.plugin.maven.runner.JVMStarter;
import org.mule.munit.plugin.maven.runner.MessageHandlerFactory;
import org.mule.munit.plugin.maven.runner.consumer.ErrorStreamConsumer;
import org.mule.munit.plugin.maven.runner.consumer.RunnerStreamConsumer;
import org.mule.munit.plugin.maven.runner.model.Debugger;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.DiscoverProduct;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.munit.plugin.maven.runtime.ProductConfiguration;
import org.mule.munit.plugin.maven.runtime.RuntimeConfiguration;
import org.mule.munit.plugin.maven.runtime.RuntimeProducts;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.ArgLinesManager;
import org.mule.munit.plugin.maven.util.ClasspathManager;
import org.mule.munit.plugin.maven.util.JarFileFactory;
import org.mule.munit.plugin.maven.util.MuleApplicationModelLoader;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.plugin.maven.util.RuntimeVersionProviderFactory;
import org.mule.munit.plugin.maven.util.properties.UserPropertiesBuilder;
import org.mule.munit.remote.RemoteRunner;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public abstract class AbstractMunitMojo
extends AbstractMojo {
    private static final List<String> MODULES = ImmutableList.of((Object)"java.base/java.lang.invoke=munit.starter", (Object)"java.base/java.lang.reflect=munit.starter", (Object)"java.base/java.lang=munit.starter", (Object)"java.sql/java.sql=munit.starter", (Object)"java.base/sun.security.provider=org.bouncycastle.fips.core");
    protected static final String ARG_TOKEN = "-";
    protected static final String RUN_CONFIGURATION_ARG = "-run_configuration";
    public static final String STARTER_CLASS_FILE = "munitstarter";
    public static final String MUNIT_PREVIOUS_RUN_PLACEHOLDER = "MUNIT_PREVIOUS_RUN_PLACEHOLDER";
    protected static final Class REMOTE_RUNNER_CLASS = RemoteRunner.class;
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    public static final String MULE_ARTIFACT_JSON_FILE_NAME = "mule-artifact.json";
    @Parameter(property="munit.test")
    public String munitTest;
    @Parameter(property="munit.tags")
    public String munitTags;
    @Parameter(property="munit.failIfNoTests", defaultValue="true")
    public boolean munitFailIfNoTests = true;
    @Parameter(property="munit.debug", defaultValue="false")
    public String munitDebug;
    @Parameter(property="runtimeVersion")
    public String runtimeVersion;
    @Parameter(property="runtimeProduct")
    public String runtimeProduct;
    @Parameter(property="runtimeLocalDistribution")
    public String runtimeLocalDistribution;
    @Parameter(defaultValue="${skipMunitTests}")
    public boolean skipMunitTests = false;
    @Parameter(defaultValue="false")
    public boolean clearParameters = false;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit")
    public File munitTestsDirectory;
    @Parameter(defaultValue="${project.build.directory}/test-mule/munit", readonly=true)
    public File defaultMunitTestsDirectory;
    @Parameter(property="project", required=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    public MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    public RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${plugin.artifactId}")
    public String pluginArtifactId;
    @Parameter(property="redirectTestOutputToFile", defaultValue="false")
    public boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/output/")
    public File testOutputDirectory;
    @Parameter(property="enableSurefireReports", defaultValue="true")
    public boolean enableSurefireReports;
    @Parameter(property="enableSonarReports", defaultValue="true")
    public boolean enableSonarReports;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    public File surefireReportsFolder;
    @Parameter(defaultValue="${project.build.directory}/sonar-reports/")
    public File sonarReportsFolder;
    @Parameter(property="skipAfterFailure", defaultValue="false")
    public boolean skipAfterFailure = false;
    @Parameter(property="munit.jvm")
    public String jvm;
    @Parameter(property="munit.addFipsProviders", defaultValue="false")
    public boolean addFipsProviders;
    @Parameter(property="munit.fipsType", defaultValue="false")
    public String fipsType;
    @Parameter(property="munit.addBootDependencies")
    public String addBootDependencies;
    @Parameter(property="munit.addOpens")
    public List<String> addOpens;
    @Parameter(property="additionalFipsProviders")
    public List<Dependency> additionalFipsDependencies;
    @Parameter(property="securityPropertiesFile")
    public String securityPropertiesFile;
    @Parameter(property="argLines")
    public List<String> argLines;
    @Parameter(property="system.property.variables")
    public Map<String, String> systemPropertyVariables;
    @Parameter(property="environment.variables")
    public Map<String, String> environmentVariables;
    @Parameter(property="dynamic.ports")
    public List<String> dynamicPorts;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    public boolean testFailureIgnore;
    @Deprecated
    @Parameter
    public RuntimeConfiguration runtimeConfiguration;
    @Parameter
    public ProductConfiguration productConfiguration;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected org.apache.maven.repository.RepositorySystem mavenRepositorySystem;
    @Parameter(property="project.build.directory", required=true)
    public File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    public ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    public List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.basedir}")
    public File projectBaseFolder;
    @Component
    protected MojoExecution execution;
    protected PluginParameterExpressionEvaluator expressionEvaluator;
    protected Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public List<File> suiteFiles;
    public JVMLocator jvmLocator;
    public JarFileFactory jarFileFactory;
    public ClasspathManager classpathManager;
    public MessageHandlerFactory messageHandlerFactory;
    public Map<String, String> effectiveSystemProperties;
    public WorkingDirectoryGenerator workingDirectoryGenerator;
    public MuleApplicationModelLoader muleApplicationModelLoader;
    public RuntimeVersionProviderFactory runtimeVersionProviderFactory;
    public ProductVersionsLocator productVersionsLocator;
    public ResultPrinterFactory resultPrinterFactory;
    private String starterJarFileName = "";
    protected Debugger debugger;
    private FipsArgumentsResolver fipsArgumentsResolver;

    protected void init() throws MojoExecutionException {
        this.expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.execution);
        this.jarFileFactory = new JarFileFactory();
        this.starterJarFileName = org.mule.munit.common.util.FileUtils.generateRandomFileName((String)STARTER_CLASS_FILE, (String)".jar");
        this.messageHandlerFactory = new MessageHandlerFactory(this.getLog());
        this.validateProperties();
        this.effectiveSystemProperties = this.getEffectiveSystemProperties();
        this.jvmLocator = new JVMLocator(this.session, this.jvm, this.toolchainManager, this.getLog());
        this.workingDirectoryGenerator = new WorkingDirectoryGenerator(this.getLog(), this.getApplicationStructureGenerator(), this.project);
        this.classpathManager = new ClasspathManager(REMOTE_RUNNER_CLASS, this.getLog());
        this.muleApplicationModelLoader = this.getMuleApplicationModelLoader();
        this.resultPrinterFactory = this.getResultPrinterFactory();
        this.initConfiguration();
        this.runtimeVersionProviderFactory = new RuntimeVersionProviderFactory(this.repositorySystem, this.repositorySystemSession, this.createRemoteRepositoriesLocator(), this.getLog());
        this.productVersionsLocator = new ProductVersionsLocator(this.runtimeVersionProviderFactory, this.getLog());
        this.debugger = Debugger.fromString(this.munitDebug);
        if (this.addFipsProviders) {
            try {
                this.fipsArgumentsResolver = new FipsArgumentsResolver(this.getLog(), this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories(), this.additionalFipsDependencies, this.securityPropertiesFile, this.fipsType);
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    protected void initConfiguration() {
        this.productConfiguration = this.runtimeConfiguration != null ? ProductConfiguration.builder().from(this.productConfiguration).withRuntimeConfiguration(RuntimeConfiguration.builder().from(this.runtimeConfiguration).build()).withOverrides(this.session.getUserProperties()).build() : ProductConfiguration.builder().from(this.productConfiguration).withOverrides(this.session.getUserProperties()).build();
        this.runtimeConfiguration = null;
    }

    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!this.skipMunitTests) {
                if (!this.hasExecutedBefore()) {
                    if (this.hasSuites()) {
                        this.init();
                        this.doExecute();
                    } else {
                        this.getLog().warn((CharSequence)"MUnit will not run, no MUnit suites found in your project");
                    }
                } else {
                    this.getLog().info((CharSequence)"Skipping execution of munit because it has already been run");
                }
            } else {
                this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_MUNIT_TESTS_PROPERTY));
            }
        } else {
            this.getLog().info((CharSequence)String.format("Run of %s skipped. Property [%s] was set to true", this.pluginArtifactId, SKIP_TESTS_PROPERTY));
        }
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(MUNIT_PREVIOUS_RUN_PLACEHOLDER)) {
            return true;
        }
        this.getPluginContext().put(MUNIT_PREVIOUS_RUN_PLACEHOLDER, MUNIT_PREVIOUS_RUN_PLACEHOLDER);
        return false;
    }

    public void doExecute() throws MojoExecutionException {
        TreeMap<TargetProduct, RunResult> runResults = new TreeMap<TargetProduct, RunResult>();
        try {
            Map<TargetProduct, RunConfiguration> runConfigurations = this.getRunConfigurations();
            for (Map.Entry<TargetProduct, RunConfiguration> runConfigurationEntry : runConfigurations.entrySet()) {
                RunConfiguration runConfiguration = runConfigurationEntry.getValue();
                this.workingDirectoryGenerator.generate(runConfiguration);
                TargetProduct targetProduct = runConfigurationEntry.getKey();
                this.getLog().info((CharSequence)String.format("Running %s with version %s", new Object[]{targetProduct.getProduct(), targetProduct.getVersion()}));
                if (runConfiguration.getSuitePaths().isEmpty()) {
                    if (this.munitFailIfNoTests) {
                        throw new MojoExecutionException("No tests suites were found! (Set -Dmunit.failIfNoTests=false to ignore this error.)");
                    }
                    this.getLog().info((CharSequence)"No MUnit test suite files found. No test will be run");
                    return;
                }
                RunnerStreamConsumer streamConsumer = new RunnerStreamConsumer(this.messageHandlerFactory.create(this.redirectTestOutputToFile));
                streamConsumer.setRunConfiguration(runConfiguration);
                ErrorStreamConsumer errorStreamConsumer = new ErrorStreamConsumer(this.redirectTestOutputToFile);
                int result = this.createTestRunExecutor(runConfiguration).execute(streamConsumer, (StreamConsumer)errorStreamConsumer);
                if (result == 0) {
                    RunResult runResult = streamConsumer.getRunResult();
                    runResults.put(targetProduct, runResult);
                    continue;
                }
                throw new MojoExecutionException("Build Failed", (Exception)new MojoExecutionException(errorStreamConsumer.getOutput()));
            }
            runResults.forEach(this::handleRunResult);
            this.failBuildIfNecessary(runResults);
        }
        catch (IOException | CommandLineException e) {
            throw new MojoExecutionException("Build Failed", (Exception)e);
        }
    }

    protected JVMStarter createTestRunExecutor(RunConfiguration runConfiguration) throws IOException, MojoExecutionException {
        File runConfigurationFile = this.saveRunConfigurationToFile(runConfiguration);
        File log4jConfigurationFile = new File(runConfiguration.getContainerConfiguration().getLog4JConfigurationFilePath());
        return this.createJVMStarter(runConfigurationFile, this.getEffectiveArgLines(this.starterJarFileName, log4jConfigurationFile), runConfiguration.getContainerConfiguration().getRuntimeId());
    }

    protected void handleRunResult(TargetProduct targetProduct, RunResult runResult) {
        for (ResultPrinter printer : this.resultPrinterFactory.create()) {
            printer.print(targetProduct, runResult);
        }
    }

    protected void failBuildIfNecessary(Map<TargetProduct, RunResult> runResults) throws MojoExecutionException {
        if (runResults.values().stream().anyMatch(RunResult::finishedWithErrors)) {
            throw new MojoExecutionException("There was an error running MUnit tests");
        }
        if (!this.testFailureIgnore && runResults.values().stream().anyMatch(RunResult::hasFailed)) {
            throw new MojoExecutionException("MUnit Tests Failed");
        }
        if (this.munitFailIfNoTests && runResults.values().stream().allMatch(result -> result.getNumberOfTests() == 0)) {
            throw new MojoExecutionException("No tests were executed! (Set -Dmunit.failIfNoTests=false to ignore this error.)");
        }
    }

    protected abstract ResultPrinterFactory getResultPrinterFactory();

    protected abstract ApplicationStructureGenerator getApplicationStructureGenerator() throws MojoExecutionException;

    protected abstract File getMuleApplicationJsonPath();

    protected abstract RunConfiguration createRunConfiguration(TargetProduct var1) throws MojoExecutionException;

    protected RunConfiguration createRunConfiguration(TargetProduct targetRuntime, String additionalTags) throws MojoExecutionException {
        return this.createRunConfiguration(targetRuntime);
    }

    protected Map<TargetProduct, RunConfiguration> getRunConfigurations() throws MojoExecutionException, IOException {
        TreeMap<TargetProduct, RunConfiguration> runConfigurations = new TreeMap<TargetProduct, RunConfiguration>();
        ArrayList<TargetProduct> effectiveTargetRuntimes = new ArrayList<TargetProduct>();
        if (this.shouldRunSingleRuntime()) {
            this.addDefaultTargetProducts(effectiveTargetRuntimes);
        } else {
            List<String> additionalProducts = this.productConfiguration.getAdditionalProducts();
            List<DiscoverProduct> productsToDiscover = this.productsToDiscover();
            if (additionalProducts != null && !additionalProducts.isEmpty()) {
                effectiveTargetRuntimes.addAll(additionalProducts.stream().map(TargetProduct::parse).collect(Collectors.toList()));
            }
            if (!productsToDiscover.isEmpty()) {
                for (DiscoverProduct discoverProduct : productsToDiscover) {
                    effectiveTargetRuntimes.addAll(this.discoverProducts(this.muleApplicationModelLoader.getRuntimeVersion(), discoverProduct));
                }
            } else {
                this.addDefaultTargetProducts(effectiveTargetRuntimes);
            }
        }
        for (TargetProduct targetRuntime : effectiveTargetRuntimes) {
            RunConfiguration runConfiguration = this.createRunConfiguration(targetRuntime);
            runConfigurations.put(targetRuntime, runConfiguration);
        }
        return runConfigurations;
    }

    protected List<DiscoverProduct> productsToDiscover() {
        return this.productConfiguration.getDiscoverProducts().stream().filter(discoverProduct -> !discoverProduct.isSkipped()).collect(Collectors.toList());
    }

    protected boolean shouldRunSingleRuntime() {
        return this.runtimeVersion != null || this.runtimeProduct != null || this.runtimeLocalDistribution != null;
    }

    private Set<TargetProduct> discoverProducts(String version, DiscoverProduct discoverProduct) throws MojoExecutionException {
        Product product = discoverProduct.getProductId().orElseThrow(() -> new MojoExecutionException(String.format("Invalid Product Configuration: the auto discovery of products was enabled but no product kind was specified, neither in the plugin nor using the command line argument '%s'. One of the following products has to be selected: %s", "discoverProducts.product", Arrays.asList(Product.values()))));
        if (this.muleApplicationModelLoader.getRuntimeProduct().equals(RuntimeProducts.EE.value()) && !product.supportsEe()) {
            throw new MojoExecutionException(String.format("Product is EE only but was configured to discover %s runtimes.", product.name()));
        }
        this.productVersionsLocator.includingSnapshots(discoverProduct.isIncludeSnapshots()).withMinVersion(discoverProduct.getMinVersion().orElse(version)).withProduct(product).usingLatestPatches(discoverProduct.isUseLatestPatches());
        return this.productVersionsLocator.locate();
    }

    protected void addDefaultTargetProducts(List<TargetProduct> effectiveTargetProducts) throws IOException, MojoExecutionException {
        effectiveTargetProducts.add(new TargetProduct(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct().equals("MULE") ? Product.MULE_CE : Product.MULE_EE));
    }

    public List<String> getEffectiveArgLines(String starterJarFileName, File log4jConfigurationFile) {
        if (!Optional.ofNullable(this.debugger).map(Debugger::getAddDebugger).orElse(false).booleanValue()) {
            return new ArgLinesManager(this.argLines, starterJarFileName, this.munitDebug, log4jConfigurationFile, this.getLog()).getEffectiveArgLines();
        }
        List<String> effectiveArgLines = new ArgLinesManager(this.argLines, starterJarFileName, null, log4jConfigurationFile, this.getLog()).getEffectiveArgLines();
        return Stream.concat(effectiveArgLines.stream(), this.debugger.getArguments().stream()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public JVMStarter createJVMStarter(File runConfigurationFile, List<String> argLines, String runtimeVersion) throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("MUnit root folder found at: " + this.munitTestsDirectory.getAbsolutePath()));
        JVMStarter jvmStarter = new JVMStarter(this.getLog()).withJVM(this.jvmLocator.locate()).withWorkingDirectory(this.getWorkingDirectory());
        String javaVersion = jvmStarter.getVersion();
        ArrayList<String> args = new ArrayList<String>();
        Consumer<String> addOpenModule = module -> {
            args.add((String)module);
            args.add("--add-opens");
            this.getLog().info((CharSequence)("--add-opens: " + module));
        };
        HashMap<String, File> fileArgLines = new HashMap<String, File>();
        if (javaVersion != null && (javaVersion.startsWith("17") || javaVersion.startsWith("21") || javaVersion.startsWith("11") && this.modularizeRuntime(runtimeVersion))) {
            this.unzipFile("munit-remote");
            this.unzipFile("munit-starter");
            ArrayList<String> modulePath = new ArrayList<String>();
            if (this.addFipsProviders) {
                modulePath.addAll(this.fipsArgumentsResolver.getClassPathEntriesForFipsProviders());
            }
            if (this.addBootDependencies != null) {
                modulePath.add(this.addBootDependencies);
            }
            args.add(this.outputDirectory.toPath().resolve("munit-remote-" + this.getVersion()).resolve("lib").toString());
            args.add("-module_path");
            args.add("munit.starter/org.mule.munit.starter.LayerStarter");
            args.add("-m");
            modulePath.add(this.outputDirectory.toPath().resolve("munit-starter-" + this.getVersion()).resolve("lib").toString());
            args.add(String.join((CharSequence)File.pathSeparator, modulePath));
            args.add("--module-path");
            MODULES.forEach(addOpenModule);
            if (this.addOpens != null) {
                this.addOpens.forEach(addOpenModule);
            }
        } else {
            List<String> classPath = this.classpathManager.getEffectiveClasspath();
            if (this.addFipsProviders) {
                classPath.addAll(this.fipsArgumentsResolver.getClassPathEntriesForFipsProviders());
            }
            File jarFile = this.jarFileFactory.create(classPath, REMOTE_RUNNER_CLASS.getCanonicalName(), new File(this.project.getBuild().getDirectory()), this.starterJarFileName);
            jvmStarter.withJar(jarFile);
            argLines.add("-Dmunit.classloader.starter.jar.file.name=" + this.starterJarFileName);
        }
        if (this.addFipsProviders) {
            argLines.add(this.fipsArgumentsResolver.getSecurePropertiesArgument());
        }
        fileArgLines.put(RUN_CONFIGURATION_ARG, runConfigurationFile);
        jvmStarter.withArgLines(args).withArgLines(fileArgLines).withArgLines(argLines).withSystemProperties(this.effectiveSystemProperties).addEnvironmentVariables(this.environmentVariables);
        return jvmStarter;
    }

    protected abstract String getVersion();

    private boolean modularizeRuntime(String runtimeVersion) {
        Matcher matcher = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*$").matcher(runtimeVersion);
        if (matcher.matches()) {
            return Version.parseVersion((String)matcher.group(1)).compareTo(Version.parseVersion((String)"4.6.0")) >= 0;
        }
        throw new IllegalArgumentException("Invalid runtimeVersion: " + runtimeVersion);
    }

    protected void unzipFile(String module) throws MojoExecutionException {
        try {
            String fileZip = Paths.get(this.localRepository.getBasedir(), new String[0]).resolve("com").resolve("mulesoft").resolve("munit").resolve(module).resolve(this.getVersion()).resolve(module + ARG_TOKEN + this.getVersion() + "-dependencies.zip").toString();
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = AbstractMunitMojo.newFile(this.outputDirectory, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public File saveRunConfigurationToFile(RunConfiguration runConfiguration) throws IOException {
        File runConfigurationFile = Paths.get(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), "run-configuration.json").toFile();
        this.saveAsJsonDataToFile(runConfiguration, runConfigurationFile);
        return runConfigurationFile;
    }

    protected void saveAsJsonDataToFile(Object data, File dataLocation) {
        try {
            if (dataLocation == null) {
                this.getLog().warn((CharSequence)"Unable to save data, no destination file was provided");
                return;
            }
            dataLocation.getParentFile().mkdirs();
            dataLocation.createNewFile();
            FileUtils.writeStringToFile((File)dataLocation, (String)this.gson.toJson(data), (Charset)Charset.defaultCharset());
            this.getLog().debug((CharSequence)("Data File saved in " + dataLocation));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to save data to file:" + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
    }

    protected MuleApplicationModelLoader getMuleApplicationModelLoader() throws MojoExecutionException {
        return new MuleApplicationModelLoader(this.getMuleApplicationModel(), this.getLog()).withRuntimeProduct(this.runtimeProduct).withRuntimeVersion(this.runtimeVersion).withRuntimeLocalDistribution(this.runtimeLocalDistribution);
    }

    protected MuleApplicationModel getMuleApplicationModel() throws MojoExecutionException {
        File muleApplicationJsonPath = this.getMuleApplicationJsonPath();
        try {
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleApplicationJsonPath, (Charset)Charset.defaultCharset()));
        }
        catch (IOException e) {
            String message = "Fail to read mule application file from " + muleApplicationJsonPath;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    public File getWorkingDirectory() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return new File(".");
    }

    private Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        effectiveSystemProperties.putAll(this.getUserSystemProperties());
        effectiveSystemProperties.put("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        return effectiveSystemProperties;
    }

    private Map<String, String> getUserSystemProperties() {
        UserPropertiesBuilder builder = new UserPropertiesBuilder(this.project.getBuild().getDirectory(), this.getLog()).withSystemPropertyVariables(this.systemPropertyVariables).withDynamicPorts(this.dynamicPorts).withUserProperties(this.session != null ? this.session.getUserProperties() : null);
        return builder.build();
    }

    private boolean hasSuites() {
        this.suiteFiles = new TestSuiteFilesLocator().locateFiles(this.munitTestsDirectory);
        return !this.suiteFiles.isEmpty();
    }

    protected RemoteRepositoriesLocator createRemoteRepositoriesLocator() {
        return new RemoteRepositoriesLocator(this.project);
    }

    public void validateProperties() throws MojoExecutionException {
        if (!org.mule.munit.common.util.FileUtils.isInDirectory((File)this.defaultMunitTestsDirectory, (File)this.munitTestsDirectory)) {
            throw new MojoExecutionException("munitTestsDirectory property must be a subfolder of ${project.build.directory}/test-mule/munit.");
        }
    }
}

