/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.mule.api.MuleEvent;
import org.mule.munit.mock.MockModule;


/**
 * VerifyCallMessageProcessor invokes the {@link org.mule.munit.mock.MockModule#verifyCall(String, java.util.List, Integer, Integer, Integer)} method in {@link org.mule.munit.mock.MockModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 */
public class VerifyCallMessageProcessor extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "verify-call";

    protected Object messageProcessor;
    protected Object withAttributes;
    protected Object times;
    protected Object atLeast;
    protected Object atMost;


    /**
     * Sets attributes
     *
     * @param value Value to set
     */
    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    /**
     * Sets messageProcessor
     *
     * @param value Value to set
     */
    public void setMessageProcessor(Object value) {
        this.messageProcessor = value;
    }

    /**
     * Sets atMost
     *
     * @param value Value to set
     */
    public void setAtMost(Object value) {
        this.atMost = value;
    }

    /**
     * Sets times
     *
     * @param value Value to set
     */
    public void setTimes(Object value) {
        this.times = value;
    }

    /**
     * Sets atLeast
     *
     * @param value Value to set
     */
    public void setAtLeast(Object value) {
        this.atLeast = value;
    }

    /**
     * Invokes the MessageProcessor.
     * <p/>
     *
     * @param muleEvent MuleEvent to be processed
     * @param module    the MockModule
     * @throws Exception
     */
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        Integer timesI = times == null ? null : Integer.valueOf((String) times);
        Integer atLeastI = atLeast == null ? null : Integer.valueOf((String) atLeast);
        Integer atMostI = atMost == null ? null : Integer.valueOf((String) atMost);

        module.verifyCall(
                (String) messageProcessor,
                transformAttributes(withAttributes, muleEvent),
                timesI,
                atLeastI,
                atMostI
        );
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }
}
