/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.mule.api.MuleEvent;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.munit.mock.MockModule;
import org.mule.munit.mock.model.MunitMuleMessage;
import org.mule.munit.wrapped.transformers.ExpressionEvaluatorTransformer;

/**
 * WhenMessageProcessor invokes the {@link org.mule.munit.mock.MockModule#when(String, java.util.List, org.mule.munit.mock.model.MunitMuleMessage, Object)} method in {@link org.mule.munit.mock.MockModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 */
public class WhenMessageProcessor extends AbstractMockMessageProcessor {

    public static final String MESSAGE_PROCESSOR_NAME = "when";

    protected Object messageProcessor;
    protected Object withAttributes;
    protected Object thenReturn;
    protected Object thenApplyTransformer;

    /**
     * Sets withAttributes
     *
     * @param value Value to set
     */
    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    /**
     * Sets thenApplyTransformer
     *
     * @param value Value to set
     */
    public void setThenApplyTransformer(Object value) {
        this.thenApplyTransformer = value;
    }

    /**
     * Sets thenReturn
     *
     * @param value Value to set
     */
    public void setThenReturn(Object value) {
        this.thenReturn = value;
    }

    /**
     * Sets messageProcessor
     *
     * @param value Value to set
     */
    public void setMessageProcessor(Object value) {
        this.messageProcessor = value;
    }

    /**
     * Invokes the MessageProcessor.
     * <p/>
     *
     * @param muleEvent MuleEvent to be processed
     * @param module    the MockModule
     * @throws Exception
     */
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        module.when(
                (String) messageProcessor,
                transformAttributes(withAttributes, muleEvent),
                transformThenReturn(muleEvent),
                evaluate(muleEvent.getMessage(), thenApplyTransformer)
        );
    }

    private MunitMuleMessage transformThenReturn(MuleEvent muleEvent) throws TransformerMessagingException {
        MunitMuleMessage munitMuleMessage = new MunitMuleMessage();

        if (thenReturn != null) {
            MunitMuleMessage originalThenReturn = (MunitMuleMessage) thenReturn;
            ExpressionEvaluatorTransformer evaluator = new ExpressionEvaluatorTransformer();

            munitMuleMessage.setPayload(evaluator.evaluate(this.muleContext, muleEvent, originalThenReturn.getPayload()));
            munitMuleMessage.setInvocationProperties(evaluateMap(originalThenReturn.getInvocationProperties(), muleEvent, muleContext));
            munitMuleMessage.setInboundProperties(evaluateMap(originalThenReturn.getInboundProperties(), muleEvent, muleContext));
            munitMuleMessage.setOutboundProperties(evaluateMap(originalThenReturn.getOutboundProperties(), muleEvent, muleContext));
            munitMuleMessage.setSessionProperties(evaluateMap(originalThenReturn.getSessionProperties(), muleEvent, muleContext));
        }
        return munitMuleMessage;
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }

}
