/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.model;


/**
 * <p>
 * Definition of the message processor attribute that wants to be mocked.
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class Attribute {

    /**
     * <p>The name of the attribute of the message processor</p>
     */
    private String name;

    /**
     * <p>The object that need to match (can be a matcher expression)</p>
     */
    private Object whereValue;


    /**
     * <p>
     * factory method to simplify test coding
     * </p>
     *
     * @param name       <p>The Name of the attribute</p>
     * @param whereValue <p>Its value</p>
     * @return <p>A new instance of the Attribute</p>
     */

    public static Attribute create(String name, String whereValue) {
        Attribute attribute = new Attribute();
        attribute.setName(name);
        attribute.setWhereValue(whereValue);
        return attribute;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getWhereValue() {
        return whereValue;
    }

    public void setWhereValue(Object whereValue) {
        this.whereValue = whereValue;
    }

    @Override
    public String toString() {
        return "Attribute{" +
                "name='" + name + '\'' +
                ", whereValue=" + whereValue +
                '}';
    }
}
