/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.processors.MuleMessageTransformer;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.mocking.EndpointMocker;
import org.mule.munit.common.mocking.MessageProcessorMocker;
import org.mule.munit.common.mocking.MunitMuleMessageTransformer;
import org.mule.munit.common.mocking.MunitSpy;
import org.mule.munit.common.mocking.MunitVerifier;
import org.mule.munit.common.mocking.NotDefinedPayload;
import org.mule.munit.common.mocking.SpyProcess;
import org.mule.munit.common.mocking.spy.SpyProcessImpl;
import org.mule.munit.common.model.Property;
import org.mule.munit.mock.model.Attribute;
import org.mule.munit.mock.model.MunitMuleMessage;
import org.mule.munit.mock.model.NestedMessageProcessor;
import org.mule.munit.wrapped.MunitDefaultMuleMessage;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;

public class MockModule
implements MuleContextAware {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private MuleContext muleContext;

    public void when(String messageProcessor, List<Attribute> withAttributes, MunitMuleMessage thenReturn, Object thenApplyTransformer) {
        this.logger.debug((Object)("Creating mock behaviour for: " + messageProcessor + " - Attributes: " + withAttributes));
        if (thenApplyTransformer instanceof AbstractMessageTransformer) {
            this.mocker().when(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(withAttributes)).thenApply((MuleMessageTransformer)new MunitMuleMessageTransformer((AbstractMessageTransformer)thenApplyTransformer));
        } else {
            MunitMuleMessage munitMuleMessage = thenReturn == null ? new MunitMuleMessage() : thenReturn;
            this.mocker().when(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(withAttributes)).thenReturn(this.createMuleMessageFrom(munitMuleMessage.getPayload(), munitMuleMessage.getMimeType(), munitMuleMessage.getEncoding(), munitMuleMessage.getInboundProperties(), munitMuleMessage.getOutboundProperties(), munitMuleMessage.getSessionProperties(), munitMuleMessage.getInvocationProperties()));
        }
    }

    public void spy(String messageProcessor, List<Attribute> withAttributes, List<MessageProcessor> assertionsBeforeCall, List<MessageProcessor> assertionsAfterCall) {
        this.logger.debug((Object)("Creating spy behaviour for: " + messageProcessor + " - Attributes: " + withAttributes));
        this.spy().spyMessageProcessor(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(withAttributes)).before(this.createSpyAssertion(assertionsBeforeCall)).after(this.createSpyAssertion(assertionsAfterCall));
    }

    public void throwAn(Throwable exception, String whenCalling, List<Attribute> withAttributes) {
        this.logger.debug((Object)("Creating throw exception behaviour for: " + whenCalling + " - Attributes: " + withAttributes));
        this.mocker().when(MessageProcessorId.getName((String)whenCalling)).ofNamespace(MessageProcessorId.getNamespace((String)whenCalling)).withAttributes(this.createAttributes(withAttributes)).thenThrow(exception);
    }

    public void verifyCall(String messageProcessor, List<Attribute> attributes, Integer times, Integer atLeast, Integer atMost) {
        try {
            MunitVerifier mockVerifier = this.verifier().verifyCallOfMessageProcessor(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(attributes));
            if (times != null) {
                mockVerifier.times(times);
            } else if (atLeast != null) {
                mockVerifier.atLeast(atLeast);
            } else if (atMost != null) {
                mockVerifier.atMost(atMost);
            } else {
                mockVerifier.atLeastOnce();
            }
        }
        catch (AssertionError error) {
            AssertionError assertionException = new AssertionError((Object)this.getMessage(error, "Verify Processor Failed"));
            ((Throwable)((Object)assertionException)).setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)this.muleContext).toArray(new StackTraceElement[0]));
            throw assertionException;
        }
    }

    public void outboundEndpoint(String address, Object returnPayload, DefaultMuleException exception, Object thenApplyTransformer, Map<String, Object> returnInvocationProperties, Map<String, Object> returnInboundProperties, Map<String, Object> returnSessionProperties, Map<String, Object> returnOutboundProperties, List<NestedProcessor> assertions) {
        if (thenApplyTransformer instanceof AbstractMessageTransformer) {
            this.endpointMocker().whenEndpointWithAddress(address).withIncomingMessageSatisfying(this.createSpyAssertion(this.createMessageProcessorsFrom(assertions))).thenApply((MuleMessageTransformer)new MunitMuleMessageTransformer((AbstractMessageTransformer)thenApplyTransformer));
        } else if (exception != null) {
            this.endpointMocker().whenEndpointWithAddress(address).withIncomingMessageSatisfying(this.createSpyAssertion(this.createMessageProcessorsFrom(assertions))).thenThrow((MuleException)exception);
        } else {
            this.endpointMocker().whenEndpointWithAddress(address).withIncomingMessageSatisfying(this.createSpyAssertion(this.createMessageProcessorsFrom(assertions))).thenReturn(this.createMuleMessageFrom(returnPayload, returnInboundProperties, returnOutboundProperties, returnSessionProperties, returnInvocationProperties));
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private MuleMessage createMuleMessageFrom(Object payload, Map<String, Object> inboundProperties, Map<String, Object> outboundProperties, Map<String, Object> sessionProperties, Map<String, Object> invocationProperties) {
        Object definedPayload = payload;
        if (payload == null) {
            definedPayload = NotDefinedPayload.getInstance();
        }
        MunitDefaultMuleMessage message = new MunitDefaultMuleMessage(definedPayload, this.muleContext);
        this.setProperties((MuleMessage)message, inboundProperties, PropertyScope.INBOUND);
        this.setProperties((MuleMessage)message, outboundProperties, PropertyScope.OUTBOUND);
        this.setProperties((MuleMessage)message, invocationProperties, PropertyScope.INVOCATION);
        return message;
    }

    private MuleMessage createMuleMessageFrom(Object payload, String mimeType, String encoding, List<Property> inboundProperties, List<Property> outboundProperties, List<Property> sessionProperties, List<Property> invocationProperties) {
        MunitDefaultMuleMessage message = new MunitDefaultMuleMessage((Object)"", this.muleContext);
        Object definedPayload = payload;
        if (payload == null) {
            definedPayload = NotDefinedPayload.getInstance();
        }
        DataType dataType = this.resolveDataType(definedPayload, mimeType, encoding);
        new MuleMessageDataTypeSetterAdapter((MuleMessage)message).setPayload(definedPayload, dataType);
        this.setProperties((MuleMessage)message, inboundProperties, PropertyScope.INBOUND);
        this.setProperties((MuleMessage)message, outboundProperties, PropertyScope.OUTBOUND);
        this.setProperties((MuleMessage)message, invocationProperties, PropertyScope.INVOCATION);
        return message;
    }

    private void setProperties(MuleMessage message, List<Property> properties, PropertyScope propertyScope) {
        if (properties != null) {
            for (Property property : properties) {
                DataType dataType = this.resolveDataType(property.getValue(), property.getMimeType(), property.getEncoding());
                new MuleMessageDataTypeSetterAdapter(message).setProperty(property.getKey(), property.getValue(), propertyScope, dataType);
            }
        }
    }

    private void setProperties(MuleMessage message, Map<String, Object> properties, PropertyScope propertyScope) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                message.setProperty(key, properties.get(key), propertyScope);
            }
        }
    }

    private DataType resolveDataType(Object value, String mimeType, String encoding) {
        Class<Object> type = value == null || value instanceof NullPayload ? Object.class : value.getClass();
        String realMimeType = StringUtils.isEmpty((String)mimeType) ? null : mimeType;
        SimpleDataType simpleDataType = new SimpleDataType(type, realMimeType);
        simpleDataType.setEncoding(encoding);
        return simpleDataType;
    }

    private List<MessageProcessor> createMessageProcessorsFrom(List<NestedProcessor> assertions) {
        if (assertions == null) {
            return null;
        }
        ArrayList<MessageProcessor> mps = new ArrayList<MessageProcessor>();
        for (NestedProcessor nestedProcessor : assertions) {
            mps.add(new NestedMessageProcessor(nestedProcessor));
        }
        return mps;
    }

    private Map<String, Object> createAttributes(List<Attribute> attributes) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes == null) {
            return attrs;
        }
        for (Attribute attr : attributes) {
            attrs.put(attr.getName(), attr.getWhereValue());
        }
        return attrs;
    }

    private List<SpyProcess> createSpyAssertion(List<MessageProcessor> messageProcessorsFrom) {
        ArrayList<SpyProcess> mps = new ArrayList<SpyProcess>(1);
        if (messageProcessorsFrom != null) {
            mps.add(this.createSpy(messageProcessorsFrom));
        }
        return mps;
    }

    protected SpyProcess createSpy(List<MessageProcessor> messageProcessorsFrom) {
        return new SpyProcessImpl(messageProcessorsFrom);
    }

    protected MessageProcessorMocker mocker() {
        return new MessageProcessorMocker(this.muleContext);
    }

    protected EndpointMocker endpointMocker() {
        return new EndpointMocker(this.muleContext);
    }

    protected MunitVerifier verifier() {
        return new MunitVerifier(this.muleContext);
    }

    protected MunitSpy spy() {
        return new MunitSpy(this.muleContext);
    }

    private String getMessage(AssertionError error, String defaultValue) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((String)message)) {
            return defaultValue;
        }
        return message;
    }
}

