/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.mock.MockModule;


/**
 * ThrowAnMessageProcessor invokes the {@link org.mule.munit.mock.MockModule#throwAn(Throwable, String, java.util.List)} method in {@link org.mule.munit.mock.MockModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 */
public class ThrowAnMessageProcessor extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "throw-an";

    protected Object exception;
    protected Object whenCalling;
    protected Object withAttributes;

    /**
     * Sets whenCalling
     *
     * @param value Value to set
     */
    public void setWhenCalling(Object value) {
        this.whenCalling = value;
    }

    /**
     * Sets withAttributes
     *
     * @param value Value to set
     */
    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    /**
     * Sets exception
     *
     * @param value Value to set
     */
    public void setException(Object value) {
        this.exception = value;
    }

    /**
     * Invokes the MessageProcessor.
     * <p/>
     *
     * @param muleEvent MuleEvent to be processed
     * @param module    the MockModule
     * @throws Exception
     */
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        MuleMessage mulemessage = muleEvent.getMessage();

        Object exceptionToThrow = evaluate(mulemessage, exception);
        Throwable throwable;
        if (Throwable.class.isAssignableFrom(exceptionToThrow.getClass())) {
            throwable = (Throwable) exceptionToThrow;
        } else {
            throw new MunitError("The MEL expression for the exception to throw didn't return an instance of java.lang.Throwable");
        }

        module.throwAn(
                throwable,
                (String) whenCalling,
                transformAttributes(withAttributes, muleEvent));
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }

}
