/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.processors;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.Property;
import org.mule.munit.mock.MockModule;
import org.mule.munit.mock.model.MunitMuleMessage;
import org.mule.munit.mock.processors.AbstractMockMessageProcessor;
import org.mule.munit.wrapped.transformers.ExpressionEvaluatorTransformer;

public class WhenMessageProcessor
extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "when";
    protected Object messageProcessor;
    protected Object withAttributes;
    protected Object thenReturn;
    protected Object thenApplyTransformer;

    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    public void setThenApplyTransformer(Object value) {
        this.thenApplyTransformer = value;
    }

    public void setThenReturn(Object value) {
        this.thenReturn = value;
    }

    public void setMessageProcessor(Object value) {
        this.messageProcessor = value;
    }

    @Override
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        module.when((String)this.messageProcessor, this.transformAttributes(this.withAttributes, muleEvent), this.transformThenReturn(muleEvent), this.evaluate(muleEvent.getMessage(), this.thenApplyTransformer));
    }

    private MunitMuleMessage transformThenReturn(MuleEvent muleEvent) throws TransformerMessagingException {
        MunitMuleMessage munitMuleMessage = new MunitMuleMessage();
        if (this.thenReturn != null) {
            MunitMuleMessage originalThenReturn = (MunitMuleMessage)this.thenReturn;
            if (this.isInvalidExpression(originalThenReturn.getPayload())) {
                throw new MunitError("mock:then-return MEL parsing fail. The payload: " + originalThenReturn.getPayload() + "is an invalid expression.");
            }
            ExpressionEvaluatorTransformer evaluator = new ExpressionEvaluatorTransformer();
            munitMuleMessage.setPayload(evaluator.evaluate(this.muleContext, muleEvent, originalThenReturn.getPayload()));
            munitMuleMessage.setMimeType(((MunitMuleMessage)this.thenReturn).getMimeType());
            munitMuleMessage.setEncoding(((MunitMuleMessage)this.thenReturn).getEncoding());
            munitMuleMessage.setInvocationProperties(this.transformProperties(originalThenReturn.getInvocationProperties(), muleEvent, this.muleContext));
            munitMuleMessage.setInboundProperties(this.transformProperties(originalThenReturn.getInboundProperties(), muleEvent, this.muleContext));
            munitMuleMessage.setOutboundProperties(this.transformProperties(originalThenReturn.getOutboundProperties(), muleEvent, this.muleContext));
            munitMuleMessage.setSessionProperties(this.transformProperties(originalThenReturn.getSessionProperties(), muleEvent, this.muleContext));
        }
        return munitMuleMessage;
    }

    protected List<Property> transformProperties(Object properties, MuleEvent muleEvent, MuleContext muleContext) throws TransformerMessagingException {
        ExpressionEvaluatorTransformer evaluator = new ExpressionEvaluatorTransformer();
        ArrayList<Property> transformedProperties = new ArrayList<Property>();
        if (properties != null) {
            for (Property p : (List)properties) {
                Property result = new Property();
                if (this.isInvalidExpression(p.getKey())) {
                    throw new MunitError("mock:the-return MEL parsing fail. The key " + p.getKey() + "is an invalid expression.");
                }
                if (this.isInvalidExpression(p.getValue())) {
                    throw new MunitError("mock:the-return MEL parsing fail. The whereValue " + p.getValue() + "is an invalid expression.");
                }
                result.setKey((String)evaluator.evaluate(muleContext, muleEvent, (Object)p.getKey()));
                result.setValue(evaluator.evaluate(muleContext, muleEvent, p.getValue()));
                result.setMimeType(p.getMimeType());
                result.setEncoding(p.getEncoding());
                transformedProperties.add(result);
            }
        }
        return transformedProperties;
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }
}

