/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.model.Event;
import org.mule.munit.mock.tool.ProcessorMocker;
import org.mule.munit.mock.tool.spy.Spy;
import org.mule.munit.mock.tool.spy.SpyProcess;
import org.mule.munit.mock.tool.spy.SpyProcessImpl;
import org.mule.munit.mock.tool.verify.Verifier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.processor.Processor;

public class MockModule {
    private transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext muleContext;

    public void when(String processor, List<Attribute> withAttributes, Event thenReturn) {
        this.logger.debug((Object)("Creating mock behaviour for: " + processor + " - Attributes: " + withAttributes));
        this.mocker().when(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(withAttributes)).thenReturn(thenReturn);
    }

    public void spy(String processor, List<Attribute> withAttributes, List<NestedProcessor> assertionsBeforeCall, List<NestedProcessor> assertionsAfterCall) {
        this.logger.debug((Object)("Creating spy behaviour for: " + processor + " - Attributes: " + withAttributes));
        this.spy().spyProcessor(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(withAttributes)).before(this.createSpyAssertion(this.createProcessorsFrom(assertionsBeforeCall))).after(this.createSpyAssertion(this.createProcessorsFrom(assertionsAfterCall)));
    }

    public void verifyCall(String processor, List<Attribute> attributes, Integer times, Integer atLeast, Integer atMost) {
        try {
            Verifier mockVerifier = this.verifier().verifyCallOfProcessor(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(attributes));
            if (times != null) {
                mockVerifier.times(times);
            } else if (atLeast != null) {
                mockVerifier.atLeast(atLeast);
            } else if (atMost != null) {
                mockVerifier.atMost(atMost);
            } else {
                mockVerifier.atLeastOnce();
            }
        }
        catch (AssertionError error) {
            AssertionError assertionException = new AssertionError((Object)this.getMessage(error, "Verify Processor Failed"));
            throw assertionException;
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private List<Processor> createProcessorsFrom(List<NestedProcessor> assertions) {
        if (assertions == null) {
            return null;
        }
        ArrayList<Processor> mps = new ArrayList<Processor>();
        return mps;
    }

    private Map<String, Object> createAttributes(List<Attribute> attributes) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes == null) {
            return attrs;
        }
        for (Attribute attr : attributes) {
            attrs.put(attr.getAttributeName(), attr.getWhereValue());
        }
        return attrs;
    }

    private List<SpyProcess> createSpyAssertion(List<Processor> processorsFrom) {
        ArrayList<SpyProcess> mps = new ArrayList<SpyProcess>(1);
        if (processorsFrom != null) {
            mps.add(this.createSpy(processorsFrom));
        }
        return mps;
    }

    protected SpyProcess createSpy(List<Processor> processorsFrom) {
        return new SpyProcessImpl(processorsFrom);
    }

    protected ProcessorMocker mocker() {
        return new ProcessorMocker(this.muleContext);
    }

    protected Verifier verifier() {
        return new Verifier(this.muleContext);
    }

    protected Spy spy() {
        return new Spy(this.muleContext);
    }

    private String getMessage(AssertionError error, String defaultValue) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return defaultValue;
        }
        return message;
    }
}

