/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.behavior;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.munit.mock.behavior.SpyBehavior;

public class DefaultBehaviorManager
implements BehaviorManager {
    public static String ID = "_munitBehaviorManager";
    private transient Log logger = LogFactory.getLog(this.getClass());
    protected List<ProcessorCall> calls = new CopyOnWriteArrayList<ProcessorCall>();
    protected List<MockBehavior> behaviors = new ArrayList<MockBehavior>();
    protected List<SpyBehavior> beforeCallProcessorSpies = new CopyOnWriteArrayList<SpyBehavior>();
    protected List<SpyBehavior> afterCallProcessorSpies = new CopyOnWriteArrayList<SpyBehavior>();

    public void reset() {
        this.calls.clear();
        this.behaviors.clear();
        this.beforeCallProcessorSpies.clear();
        this.afterCallProcessorSpies.clear();
    }

    public synchronized void addBehavior(MockBehavior behavior) {
        this.behaviors.add(behavior);
    }

    public synchronized void addCall(ProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addBeforeCallSpyAssertion(SpyBehavior spyBehavior) {
        this.beforeCallProcessorSpies.add(spyBehavior);
    }

    public synchronized void addAfterCallSpyAssertion(SpyBehavior spyBehavior) {
        this.afterCallProcessorSpies.add(spyBehavior);
    }

    public MockBehavior getBetterMatchingBehavior(ProcessorCall processorCall) {
        return this.getBetterMatchingAction(processorCall, this.behaviors);
    }

    public List<ProcessorCall> findCallsFor(ProcessorId mpId, Map<String, Object> attributesMatchers) {
        this.logger.debug((Object)("Finding calls for message processor: " + mpId.getFullName()));
        ArrayList<ProcessorCall> expected = new ArrayList<ProcessorCall>();
        ProcessorCall matchingCall = new ProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (ProcessorCall call : this.calls) {
            if (matchingCall.matchingWeight(call) < 0) continue;
            expected.add(call);
        }
        return expected;
    }

    public SpyBehavior getBetterMatchingBeforeSpyAssertion(ProcessorCall processorCall) {
        this.logger.debug((Object)("Finding Spy Before for: " + processorCall.getProcessorId().getFullName()));
        return this.getBetterMatchingAction(processorCall, this.beforeCallProcessorSpies);
    }

    public SpyBehavior getBetterMatchingAfterSpyAssertion(ProcessorCall processorCall) {
        this.logger.debug((Object)("Finding Spy After for: " + processorCall.getProcessorId().getFullName()));
        return this.getBetterMatchingAction(processorCall, this.afterCallProcessorSpies);
    }

    protected <T extends Behavior> T getBetterMatchingAction(ProcessorCall processorCall, Collection<T> actions) {
        AbstractMap.SimpleEntry<Integer, Object> bestMatchingBehavior = new AbstractMap.SimpleEntry<Integer, Object>(0, null);
        for (Behavior behavior : actions) {
            int matchingWeight = behavior.getProcessorCall().matchingWeight(processorCall);
            if (matchingWeight < 0 || matchingWeight < (Integer)bestMatchingBehavior.getKey()) continue;
            bestMatchingBehavior.setValue(behavior);
        }
        return (T)((Behavior)bestMatchingBehavior.getValue());
    }

    protected List<ProcessorCall> getCalls() {
        return new LinkedList<ProcessorCall>(this.calls);
    }
}

