/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.EventError;
import org.mule.munit.common.util.MunitUtils;
import org.mule.munit.mock.behavior.DefaultBehaviorManager;
import org.mule.munit.mock.behavior.MockBehavior;
import org.mule.munit.mock.behavior.SpyBehavior;
import org.mule.munit.mock.interception.InterceptingEventBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.ErrorTypeRepository;

public class MunitProcessorInterceptor
implements ProcessorInterceptor {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Object> beforeParameters;
    private DefaultBehaviorManager manager;
    private ErrorTypeRepository errorTypeRepository;

    public void setManager(BehaviorManager manager) {
        this.manager = (DefaultBehaviorManager)manager;
    }

    protected DefaultBehaviorManager getManager() {
        if (this.manager == null) {
            throw new IllegalStateException("There is no manager defined");
        }
        return this.manager;
    }

    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
        this.logger.debug((Object)("About to run Spy Before processor: " + this.getIdentifier(location)));
        this.setBeforeParameters(parameters);
        ProcessorCall processorCall = this.buildCall(this.getIdentifier(location), parameters);
        this.getManager().addCall(processorCall);
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
        this.logger.debug((Object)("Retrieving mocked behavior for processor: " + this.getIdentifier(location)));
        MockBehavior behavior = this.getManager().getBetterMatchingBehavior(this.buildCall(this.getIdentifier(location), parameters));
        if (behavior != null) {
            if (this.shouldFailProcessor(behavior)) {
                this.logger.debug((Object)("Mock behavior found. Throwing exception instead of " + this.getIdentifier(location)));
                return this.failProcessor(event, action, behavior);
            }
            this.logger.debug((Object)("Mock behavior found. Executing that instead of " + this.getIdentifier(location)));
            return this.returnBehavior(event, action, behavior);
        }
        return action.proceed();
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        this.logger.debug((Object)("About to run Spy After for processor: " + this.getIdentifier(location)));
    }

    private ComponentIdentifier getIdentifier(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier();
    }

    private synchronized Map<String, Object> getBeforeParameters() {
        return this.beforeParameters;
    }

    private synchronized void setBeforeParameters(Map<String, Object> beforeParameters) {
        this.beforeParameters = beforeParameters;
    }

    private ProcessorCall buildCall(ComponentIdentifier componentIdentifier, Map<String, Object> parameters) {
        ProcessorId id = new ProcessorId(componentIdentifier.getName(), componentIdentifier.getNamespace());
        ProcessorCall call = new ProcessorCall(id);
        call.setAttributes(parameters);
        return call;
    }

    private boolean shouldFailProcessor(MockBehavior behavior) {
        Optional<Event> behaviorEvent = behavior.getEvent();
        EventError behaviorError = behaviorEvent.isPresent() ? behaviorEvent.get().getError() : null;
        boolean isThereAnEvent = behaviorEvent.isPresent();
        boolean isThereAnErrorCause = behaviorError != null ? (Throwable)behaviorError.getCause() != null : false;
        boolean isThereAnErrorTypeId = behaviorError != null ? StringUtils.isNotBlank((CharSequence)behaviorError.getTypeId()) : false;
        return isThereAnEvent && (isThereAnErrorCause || isThereAnErrorTypeId);
    }

    private CompletableFuture<InterceptionEvent> returnBehavior(InterceptionEvent event, InterceptionAction action, MockBehavior behavior) {
        action.skip();
        Optional<Event> mockedEvent = behavior.getEvent();
        return CompletableFuture.supplyAsync(() -> this.buildInterceptingEvent(event, mockedEvent));
    }

    private CompletableFuture<InterceptionEvent> failProcessor(InterceptionEvent event, InterceptionAction action, MockBehavior behavior) {
        this.buildInterceptingEvent(event, behavior.getEvent());
        Event behaviorEvent = behavior.getEvent().get();
        if (behaviorEvent.getError().getCause() != null) {
            return action.fail((Throwable)behaviorEvent.getError().getCause());
        }
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)behaviorEvent.getError().getTypeId());
        Optional errorType = this.errorTypeRepository.getErrorType(componentIdentifier);
        return action.fail((ErrorType)errorType.get());
    }

    private InterceptionEvent buildInterceptingEvent(InterceptionEvent originalEvent, Optional<Event> mockedEvent) {
        return new InterceptingEventBuilder().build(originalEvent, mockedEvent);
    }

    private void runSpyAssertion(SpyBehavior spyBehavior, org.mule.runtime.core.api.Event event) {
        if (spyBehavior == null) {
            this.logger.debug((Object)"No Spy was found to be run.");
            return;
        }
        this.logger.debug((Object)"Running Spy");
        MunitUtils.verifyAssertions((org.mule.runtime.core.api.Event)event, spyBehavior.getProcessors());
    }
}

