/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.munit.mock;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.model.Event;
import org.mule.munit.mock.tool.ProcessorMocker;
import org.mule.munit.mock.tool.spy.Spy;
import org.mule.munit.mock.tool.spy.SpyProcess;
import org.mule.munit.mock.tool.spy.SpyProcessImpl;
import org.mule.munit.mock.tool.verify.Verifier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.processor.Processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.mule.munit.common.behavior.ProcessorId.getName;
import static org.mule.munit.common.behavior.ProcessorId.getNamespace;

/**
 * MUnit module for mocking processors.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MockModule {

  private transient Log logger = LogFactory.getLog(this.getClass());

  protected MuleContext muleContext;

  /**
   * Define what the mock must return on a message processor call. If the message processor doesn't return any value then there is
   * no need to define an expect. You can define the message processor parameters in the same order they appear in the API
   * documentation. In order to define the behaviour on that particular case.
   *
   *
   * @param processor processor name.
   * @param thenReturn Expected return value.
   * @param withAttributes Message processor parameters.
   */

  public void when(String processor, List<Attribute> withAttributes, Event thenReturn) {
    logger.debug("Creating mock behaviour for: " + processor + " - Attributes: " + withAttributes);

    mocker()
        .when(getName(processor))
        .ofNamespace(getNamespace(processor))
        .withAttributes(createAttributes(withAttributes))
        .thenReturn(thenReturn);
  }

  /**
   * Define what the mock must return on a processor call. If the processor doesn't return any value then there is no need to
   * define an expect. You can define the processor parameters in the same order they appear in the API documentation. In order to
   * define the behaviour on that particular case.
   *
   *
   * @param processor processor name.
   * @param withAttributes Sets of attributes to narrow-down a specific processor
   * @param assertionsBeforeCall Expected return value.
   * @param assertionsAfterCall processor parameters.
   */
  public void spy(String processor,
                  List<Attribute> withAttributes,
                  List<NestedProcessor> assertionsBeforeCall,
                  List<NestedProcessor> assertionsAfterCall) {

    logger.debug("Creating spy behaviour for: " + processor + " - Attributes: " + withAttributes);

    spy().spyProcessor(getName(processor))
        .ofNamespace(getNamespace(processor))
        .withAttributes(createAttributes(withAttributes))
        .before(createSpyAssertion(createProcessorsFrom(assertionsBeforeCall)))
        .after(createSpyAssertion(createProcessorsFrom(assertionsAfterCall)));
  }

  /**
   * Check that the processor was called with some specified parameters
   *
   * @param processor processor Id
   * @param attributes processor parameters.
   * @param times Number of times the processor has to be called
   * @param atLeast Number of time the processor has to be called at least.
   * @param atMost Number of times the processor has to be called at most.
   */
  public void verifyCall(String processor, List<Attribute> attributes, Integer times, Integer atLeast, Integer atMost) {
    try {
      Verifier mockVerifier = verifier().verifyCallOfProcessor(getName(processor)).ofNamespace(getNamespace(processor))
          .withAttributes(createAttributes(attributes));

      if (times != null) {
        mockVerifier.times(times);

      } else if (atLeast != null) {
        mockVerifier.atLeast(atLeast);
      } else if (atMost != null) {
        mockVerifier.atMost(atMost);
      } else {
        mockVerifier.atLeastOnce();
      }

    } catch (AssertionError error) {
      AssertionError assertionException = new AssertionError(getMessage(error, "Verify Processor Failed"));
      throw assertionException;
    }
  }

  public void setMuleContext(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  private List<Processor> createProcessorsFrom(List<NestedProcessor> assertions) {
    if (assertions == null) {
      return null;
    }
    // TODO fix this when reimplementing the mock
    List<Processor> mps = new ArrayList<>();
    // for (NestedProcessor nestedProcessor : assertions) {
    // mps.add(new NestedProcessorChain(nestedProcessor));
    // }

    return mps;
  }

  private Map<String, Object> createAttributes(List<Attribute> attributes) {
    Map<String, Object> attrs = new HashMap<>();
    if (attributes == null) {
      return attrs;
    }

    for (Attribute attr : attributes) {
      attrs.put(attr.getAttributeName(), attr.getWhereValue());
    }

    return attrs;
  }

  private List<SpyProcess> createSpyAssertion(final List<Processor> processorsFrom) {
    List<SpyProcess> mps = new ArrayList<>(1);
    if (processorsFrom != null) {
      mps.add(createSpy(processorsFrom));
    }
    return mps;
  }

  protected SpyProcess createSpy(final List<Processor> processorsFrom) {
    return new SpyProcessImpl(processorsFrom);
  }

  protected ProcessorMocker mocker() {
    return new ProcessorMocker(muleContext);
  }

  protected Verifier verifier() {
    return new Verifier(muleContext);
  }

  protected Spy spy() {
    return new Spy(muleContext);
  }

  private String getMessage(AssertionError error, String defaultValue) {
    String message = error.getMessage();
    if (StringUtils.isEmpty(message)) {
      return defaultValue;
    }
    return message;
  }

}
