/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.behavior;

import java.util.ArrayList;
import java.util.List;

import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.runtime.core.api.processor.Processor;

/**
 * Represents a behavior to be executed before/after a processor call. This particular behavior is composed by other processors.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class SpyBehavior extends Behavior {

  /**
   * The processors to be executed for the call
   */
  private List<Processor> processors = new ArrayList<>();

  public SpyBehavior(ProcessorCall processorCall, List<Processor> processors) {
    super(processorCall);
    this.processors = processors;
  }

  public List<Processor> getProcessors() {
    return processors;
  }

  public void setProcessors(List<Processor> processors) {
    this.processors = processors;
  }

}
