/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.config;

import org.mule.munit.common.model.*;
import org.mule.munit.mock.MockModule;
import org.mule.munit.mock.processors.SpyProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;

import java.util.LinkedList;
import java.util.List;

import static org.mule.munit.mock.config.MockXmlNamespaceInfoProvider.NAME_SPACE;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.*;
import static org.mule.runtime.dsl.api.component.TypeDefinition.fromType;

public class MockComponentBuildingDefinitionProvider implements ComponentBuildingDefinitionProvider {

  public static final String CONFIG = "config";
  public static final String SPY = "spy";
  public static final String THROW_AN = "throw-an";


  private static ComponentBuildingDefinition.Builder baseDefinition =
      new ComponentBuildingDefinition.Builder().withNamespace(NAME_SPACE);


  @Override
  public void init() {}

  @Override
  public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
    LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<>();

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(CONFIG)
                                         .withTypeDefinition(fromType(MockModule.class))
                                         .build());



    //        componentBuildingDefinitions.add(
    //            baseDefinition.copy()
    //                .withIdentifier(THROW_AN)
    //                .asPrototype()
    //                .withTypeDefinition(fromType(ThrowAnProcessor.class))
    //                .withSetterParameterDefinition("config-ref", fromSimpleParameter("moduleObject").build())
    //                .withSetterParameterDefinition("exception-ref", fromSimpleParameter("exception").build())
    //                .withSetterParameterDefinition("whenCalling", fromSimpleParameter("whenCalling").build())
    //                .withSetterParameterDefinition("with-attributes", fromChildConfiguration(List.class).build())
    //                .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(SPY)
                                         .asPrototype()
                                         .withTypeDefinition(fromType(SpyProcessor.class))
                                         //                .withSetterParameterDefinition("config-ref", fromSimpleParameter("moduleObject").build())
                                         .withSetterParameterDefinition("messageProcessor",
                                                                        fromSimpleParameter("processor").build())
                                         .withSetterParameterDefinition("withAttributes",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("with-attributes").build())
                                         .withSetterParameterDefinition("assertions-before-call",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .withSetterParameterDefinition("assertions-after-call",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy().withIdentifier("with-attributes")
                                         .withTypeDefinition(fromType(List.class)).build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("with-attribute")
                                         .withTypeDefinition(fromType(Attribute.class))
                                         .withSetterParameterDefinition("name", fromSimpleParameter("attributeName").build())
                                         .withSetterParameterDefinition("whereValue", fromSimpleParameter("whereValue").build())
                                         .build());


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("then-return")
                                         .asPrototype()
                                         .withTypeDefinition(fromType(Event.class))
                                         .withSetterParameterDefinition("payload",
                                                                        fromChildConfiguration(Payload.class)
                                                                            .withIdentifier("payload").build())
                                         .withSetterParameterDefinition("attributes",
                                                                        fromChildConfiguration(EventAttributes.class)
                                                                            .withIdentifier("attributes").build())
                                         .withSetterParameterDefinition("error",
                                                                        fromChildConfiguration(EventError.class)
                                                                            .withIdentifier("error").build())
                                         .withSetterParameterDefinition("variables",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("variables").build())
                                         .withSetterParameterDefinition("inboundProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("inbound-properties").build())
                                         .withSetterParameterDefinition("sessionProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("session-properties").build())
                                         .withSetterParameterDefinition("outboundProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("outbound-properties").build())
                                         .withSetterParameterDefinition("inboundAttachments",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("inbound-attachments").build())
                                         .withSetterParameterDefinition("outboundAttachments",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("outbound-attachments").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("payload")
                                         .withTypeDefinition(fromType(Payload.class))
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("attributes")
                                         .withTypeDefinition(fromType(EventAttributes.class))
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .asPrototype()
                                         .withIdentifier("error")
                                         .withTypeDefinition(fromType(EventError.class))
                                         .withSetterParameterDefinition("typeId", fromSimpleParameter("id").build())
                                         .withSetterParameterDefinition("cause", fromSimpleParameter("exception").build())
                                         .build());

    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("variables").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("inbound-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("session-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("outbound-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("inbound-attachments").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("outbound-attachments").withTypeDefinition(fromType(List.class)).build());


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("variable")
                                         .withTypeDefinition(fromType(Variable.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("inbound-property")
                                         .withTypeDefinition(fromType(Property.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("session-property")
                                         .withTypeDefinition(fromType(Property.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("outbound-property")
                                         .withTypeDefinition(fromType(Property.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("inbound-attachment")
                                         .withTypeDefinition(fromType(Attachment.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("outbound-attachment")
                                         .withTypeDefinition(fromType(Attachment.class))
                                         .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());


    return componentBuildingDefinitions;
  }


}
