/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.munit.mock.config;


import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

import java.util.Collection;

import static java.util.Arrays.asList;

/**
 * @since 4.0
 */
public class MockXmlNamespaceInfoProvider implements XmlNamespaceInfoProvider {

  public static final String NAME_SPACE = "mock";

  @Override
  public Collection<XmlNamespaceInfo> getXmlNamespacesInfo() {
    return asList(new XmlNamespaceInfo() {

      @Override
      public String getNamespaceUriPrefix() {
        return "http://www.mulesoft.org/schema/mule/mock";
      }

      @Override
      public String getNamespace() {
        return NAME_SPACE;
      }
    });
  }
}
